/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.ReceiptApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.receipt.ReadMarkersRequest;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ReceiptMethods
extends AbstractMethods {
    public ReceiptMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<EmptyResponse> sendReceipt(Id roomId, Id eventId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId.toString()).path("eventId", eventId.toString()).path("receiptType", "m.read");
        return this.factory().post(ReceiptApi.class, "receipt", params, "", EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> readMarkers(Id roomId, ReadMarkersRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId.toString());
        return this.factory().post(ReceiptApi.class, "readMarkers", params, request, EmptyResponse.class);
    }
}

