/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.PresenceApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.presence.PresenceList;
import io.github.ma1uta.matrix.client.model.presence.PresenceStatus;
import io.github.ma1uta.matrix.event.Event;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.GenericType;

public class PresenceMethods
extends AbstractMethods {
    public PresenceMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<EmptyResponse> setPresenceStatus(PresenceStatus status) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(status.getPresence(), "Presence cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().put(PresenceApi.class, "setPresenceStatus", params, status, EmptyResponse.class);
    }

    public CompletableFuture<PresenceStatus> getPresenceStatus(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().get(PresenceApi.class, "getPresenceStatus", params, PresenceStatus.class);
    }

    public CompletableFuture<EmptyResponse> setPresenceList(PresenceList presenceList) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().post(PresenceApi.class, "setPresenceList", params, presenceList, EmptyResponse.class);
    }

    public CompletableFuture<List<Event>> getPresenceList(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId);
        return this.factory().get(PresenceApi.class, "getPresenceList", params, new GenericType<List<Event>>(){});
    }
}

