/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.ContentApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.content.ContentConfig;
import io.github.ma1uta.matrix.client.model.content.ContentUri;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.GenericType;

public class ContentMethods
extends AbstractMethods {
    public ContentMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<String> upload(InputStream inputStream, String filename, String contentType) {
        RequestParams params = this.defaults().clone().query("filename", filename).header("Content-Type", contentType);
        return this.factory().post(ContentApi.class, "upload", params, inputStream, ContentUri.class, contentType).thenApply(ContentUri::getContentUri);
    }

    public CompletableFuture<InputStream> download(String serverName, String mediaId, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        RequestParams params = this.defaults().clone().path("serverName", serverName).path("mediaId", mediaId).query("allowRemote", allowRemote);
        return this.factory().get(ContentApi.class, "download", params, InputStream.class);
    }

    public CompletableFuture<InputStream> thumbnail(String serverName, String mediaId, Long width, Long height, String method, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        RequestParams params = this.defaults().clone().path("serverName", serverName).path("mediaId", mediaId).query("width", width).query("height", height).query("method", method).query("allowRemote", allowRemote);
        return this.factory().get(ContentApi.class, "thumbnail", params, InputStream.class);
    }

    public CompletableFuture<Map<String, String>> previewInfo(String url, String ts) {
        Objects.requireNonNull(url, "Url cannot be empty.");
        RequestParams params = this.defaults().clone().query("url", url).query("ts", ts);
        return this.factory().get(ContentApi.class, "previewUrl", params, new GenericType<Map<String, String>>(){});
    }

    public CompletableFuture<Long> getUploadSize() {
        return this.factory().get(ContentApi.class, "config", new RequestParams(), ContentConfig.class).thenApply(ContentConfig::getUploadSize);
    }
}

