/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.AccountApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.account.AuthenticationData;
import io.github.ma1uta.matrix.client.model.account.AvailableResponse;
import io.github.ma1uta.matrix.client.model.account.DeactivateRequest;
import io.github.ma1uta.matrix.client.model.account.Delete3PidRequest;
import io.github.ma1uta.matrix.client.model.account.EmailRequestToken;
import io.github.ma1uta.matrix.client.model.account.MsisdnRequestToken;
import io.github.ma1uta.matrix.client.model.account.PasswordRequest;
import io.github.ma1uta.matrix.client.model.account.RegisterRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidResponse;
import io.github.ma1uta.matrix.client.model.account.WhoamiResponse;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.thirdpid.SessionResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class AccountMethods
extends AbstractMethods {
    private final Function<LoginResponse, LoginResponse> afterLogin;

    public AccountMethods(RequestFactory factory, RequestParams defaultParams, Function<LoginResponse, LoginResponse> afterLogin) {
        super(factory, defaultParams);
        this.afterLogin = afterLogin;
    }

    protected Function<LoginResponse, LoginResponse> getAfterLogin() {
        return this.afterLogin;
    }

    public CompletableFuture<LoginResponse> register(RegisterRequest request) {
        RequestParams params = this.defaults().clone().query("kind", "user");
        return this.factory().post(AccountApi.class, "register", params, request, LoginResponse.class).thenApply(this.getAfterLogin());
    }

    public CompletableFuture<SessionResponse> emailRequestToken(EmailRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getEmail(), "Email cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.factory().post(AccountApi.class, "emailRequestToken", this.defaults(), requestToken, SessionResponse.class);
    }

    public CompletableFuture<SessionResponse> msisdnRequestToken(MsisdnRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getCountry(), "Country cannot be empty.");
        Objects.requireNonNull(requestToken.getPhoneNumber(), "Phone number cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.factory().post(AccountApi.class, "msisdnRequestToken", this.defaults(), requestToken, SessionResponse.class);
    }

    public CompletableFuture<EmptyResponse> password(char[] password, AuthenticationData auth) {
        Objects.requireNonNull(password, "Password cannot be empty.");
        PasswordRequest request = new PasswordRequest();
        request.setNewPassword(password);
        request.setAuth(auth);
        return this.factory().post(AccountApi.class, "password", this.defaults(), request, EmptyResponse.class);
    }

    public CompletableFuture<SessionResponse> passwordEmailRequestToken(EmailRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getEmail(), "Email cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.factory().post(AccountApi.class, "passwordEmailRequestToken", this.defaults(), requestToken, SessionResponse.class);
    }

    public CompletableFuture<SessionResponse> passwordMsisdnRequestToken(MsisdnRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getCountry(), "Country cannot be empty.");
        Objects.requireNonNull(requestToken.getPhoneNumber(), "Phone number cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.factory().post(AccountApi.class, "passwordMsisdnRequestToken", this.defaults(), requestToken, SessionResponse.class);
    }

    public CompletableFuture<EmptyResponse> deactivate(AuthenticationData auth) {
        DeactivateRequest request = new DeactivateRequest();
        request.setAuth(auth);
        return this.factory().post(AccountApi.class, "deactivate", this.defaults(), request, EmptyResponse.class);
    }

    public CompletableFuture<Boolean> available(String username) {
        Objects.requireNonNull(username, "Username cannot be empty");
        RequestParams params = this.defaults().clone().query("username", username);
        return this.factory().get(AccountApi.class, "available", params, AvailableResponse.class).thenApply(AvailableResponse::getAvailable);
    }

    public CompletableFuture<ThreePidResponse> getThreePid() {
        return this.factory().get(AccountApi.class, "getThreePid", this.defaults(), ThreePidResponse.class);
    }

    public CompletableFuture<EmptyResponse> updateThreePid(ThreePidRequest request) {
        String error = "Threepids cannot be empty.";
        Objects.requireNonNull(request.getThreePidCreds(), error);
        return this.factory().post(AccountApi.class, "updateThreePid", this.defaults(), request, EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> deleteThreePid(String medium, String address) {
        Objects.requireNonNull(medium, "Medium cannot be empty.");
        Objects.requireNonNull(address, "Address cannot be empty.");
        Delete3PidRequest request = new Delete3PidRequest();
        request.setMedium(medium);
        request.setAddress(address);
        return this.factory().post(AccountApi.class, "deleteThreePid", this.defaults(), request, EmptyResponse.class);
    }

    public CompletableFuture<SessionResponse> threePidEmailRequestToken(EmailRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getEmail(), "Email cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.factory().post(AccountApi.class, "threePidEmailRequestToken", this.defaults(), requestToken, SessionResponse.class);
    }

    public CompletableFuture<SessionResponse> threePidMsisdnRequestToken(MsisdnRequestToken requestToken) {
        Objects.requireNonNull(requestToken.getClientSecret(), "Client secret cannot be empty.");
        Objects.requireNonNull(requestToken.getCountry(), "Country cannot be empty.");
        Objects.requireNonNull(requestToken.getPhoneNumber(), "Phone number cannot be empty.");
        Objects.requireNonNull(requestToken.getSendAttempt(), "Send attempt cannot be empty.");
        return this.factory().post(AccountApi.class, "threePidMsisdnRequestToken", this.defaults(), requestToken, SessionResponse.class);
    }

    public CompletableFuture<WhoamiResponse> whoami() {
        return this.factory().get(AccountApi.class, "whoami", this.defaults(), WhoamiResponse.class);
    }
}

