/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import java.util.Objects;

public abstract class AbstractClientBuilder<C> {
    private RequestParams defaultParams = new RequestParams();
    private RequestFactory factory;

    protected AbstractClientBuilder() {
    }

    protected RequestParams getDefaultParams() {
        return this.defaultParams;
    }

    public RequestFactory getFactory() {
        return this.factory;
    }

    public AbstractClientBuilder<C> userId(String userId) {
        this.defaultParams.userId(userId);
        return this;
    }

    public AbstractClientBuilder<C> accessToken(String accessToken) {
        this.defaultParams.accessToken(accessToken);
        return this;
    }

    public AbstractClientBuilder<C> requestFactory(RequestFactory factory) {
        this.factory = factory;
        return this;
    }

    public C build() {
        Objects.requireNonNull(this.factory, "Request factory must be set.");
        return this.newInstance();
    }

    protected abstract C newInstance();
}

