/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.client.model.encryption.ChangesResponse;
import io.github.ma1uta.matrix.client.model.encryption.ClaimRequest;
import io.github.ma1uta.matrix.client.model.encryption.ClaimResponse;
import io.github.ma1uta.matrix.client.model.encryption.QueryRequest;
import io.github.ma1uta.matrix.client.model.encryption.QueryResponse;
import io.github.ma1uta.matrix.client.model.encryption.UploadRequest;
import io.github.ma1uta.matrix.client.model.encryption.UploadResponse;
import io.github.ma1uta.matrix.client.rest.async.EncryptionApi;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class EncryptionAsyncMethods {
    private final EncryptionApi encryptionApi;

    public EncryptionAsyncMethods(RestClientBuilder restClientBuilder) {
        this.encryptionApi = (EncryptionApi)restClientBuilder.build(EncryptionApi.class);
    }

    public CompletableFuture<UploadResponse> uploadKey(UploadRequest request) {
        return this.encryptionApi.uploadKey(request).toCompletableFuture();
    }

    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        if (request.getDeviceKeys() == null || request.getDeviceKeys().isEmpty()) {
            throw new NullPointerException("DeviceKeys cannot be empty.");
        }
        return this.encryptionApi.query(request).toCompletableFuture();
    }

    public CompletableFuture<ClaimResponse> claim(ClaimRequest request) {
        if (request.getOneTimeKeys().isEmpty()) {
            throw new NullPointerException("OneTimeKeys cannot be empty.");
        }
        return this.encryptionApi.claim(request).toCompletableFuture();
    }

    public CompletableFuture<ChangesResponse> changes(String from, String to) {
        Objects.requireNonNull(from, "From cannot be empty.");
        Objects.requireNonNull(to, "To cannot be empty.");
        return this.encryptionApi.changes(from, to).toCompletableFuture();
    }
}

