/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.account.AuthenticationData;
import io.github.ma1uta.matrix.client.model.device.Device;
import io.github.ma1uta.matrix.client.model.device.DeviceUpdateRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesResponse;
import io.github.ma1uta.matrix.client.rest.async.DeviceApi;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class DeviceAsyncMethods {
    private final DeviceApi deviceApi;
    private final ConnectionInfo connectionInfo;

    public DeviceAsyncMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.deviceApi = (DeviceApi)restClientBuilder.build(DeviceApi.class);
        this.connectionInfo = connectionInfo;
    }

    public CompletableFuture<DevicesResponse> devices() {
        return this.deviceApi.devices().toCompletableFuture();
    }

    public CompletableFuture<Device> device(String deviceId) {
        Objects.requireNonNull(deviceId, "DeviceId cannot be empty.");
        return this.deviceApi.device(deviceId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> update(String deviceId, String displayName) {
        Objects.requireNonNull(deviceId, "DeviceId cannot be empty.");
        DeviceUpdateRequest request = new DeviceUpdateRequest();
        request.setDisplayName(displayName);
        return this.deviceApi.updateDevice(deviceId, request).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> delete(AuthenticationData auth) {
        DevicesDeleteRequest request = new DevicesDeleteRequest();
        request.setAuth(auth);
        List<String> devices = Collections.singletonList(this.connectionInfo.getDeviceId());
        request.setDevices(devices);
        return this.deviceApi.deleteDevices(request).thenApply(r -> {
            this.connectionInfo.setDeviceId(null);
            this.connectionInfo.setAccessToken(null);
            return r;
        }).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> deleteDevices(DevicesDeleteRequest request) {
        String error = "Devices cannot be empty.";
        Objects.requireNonNull(request.getDevices(), error);
        if (request.getDevices().isEmpty()) {
            throw new NullPointerException(error);
        }
        return this.deviceApi.deleteDevices(request).thenApply(r -> {
            if (request.getDevices().contains(this.connectionInfo.getDeviceId())) {
                this.connectionInfo.setDeviceId(null);
                this.connectionInfo.setAccessToken(null);
            }
            return r;
        }).toCompletableFuture();
    }
}

