/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.AbstractClientBuilder;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.filter.UserIdClientFilter;
import io.github.ma1uta.matrix.client.methods.AccountMethods;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class AppServiceClient
extends MatrixClient {
    private final UserIdClientFilter userIdClientFilter;

    public AppServiceClient(String domain) {
        this(new ConnectionInfo(domain));
    }

    public AppServiceClient(ConnectionInfo connectionInfo) {
        super(connectionInfo);
        String userId = connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId must be configured.");
        String accessToken = connectionInfo.getAccessToken();
        Objects.requireNonNull(accessToken, "AccessToken must be configured");
        this.userIdClientFilter = new UserIdClientFilter(connectionInfo);
    }

    @Override
    protected RestClientBuilder newClientBuilder() {
        return (RestClientBuilder)super.newClientBuilder().register((Object)this.userIdClientFilter);
    }

    public AppServiceClient userId(String userId) {
        ConnectionInfo newConnectionInfo = new ConnectionInfo(this.getConnectionInfo());
        newConnectionInfo.setUserId(userId);
        return new AppServiceClient(newConnectionInfo);
    }

    @Override
    public AccountMethods account() {
        return this.getMethod(AccountMethods.class, () -> new AccountMethods(this.getClientBuilder(), Function.identity()));
    }

    public static class Builder
    extends AbstractClientBuilder<AppServiceClient> {
        @Override
        public AppServiceClient newInstance() {
            return new AppServiceClient(this.connectionInfo);
        }
    }
}

