/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import java.util.Objects;

public abstract class AbstractClientBuilder<C> {
    protected ConnectionInfo connectionInfo = new ConnectionInfo();

    protected AbstractClientBuilder() {
    }

    public AbstractClientBuilder<C> userId(String userId) {
        this.connectionInfo.setUserId(userId);
        return this;
    }

    public AbstractClientBuilder<C> accessToken(String accessToken) {
        this.connectionInfo.setAccessToken(accessToken);
        return this;
    }

    public AbstractClientBuilder<C> domain(String domain) {
        this.connectionInfo.setDomain(domain);
        return this;
    }

    public C build() {
        Objects.requireNonNull(this.connectionInfo.getDomain(), "Domain must be set.");
        return this.newInstance();
    }

    protected abstract C newInstance();
}

