/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.profile.AvatarUrl;
import io.github.ma1uta.matrix.client.model.profile.DisplayName;
import io.github.ma1uta.matrix.client.model.profile.Profile;
import io.github.ma1uta.matrix.client.rest.ProfileApi;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ProfileMethods {
    private final ProfileApi profileApi;
    private final ConnectionInfo connectionInfo;

    public ProfileMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.profileApi = (ProfileApi)restClientBuilder.build(ProfileApi.class);
        this.connectionInfo = connectionInfo;
    }

    public CompletableFuture<EmptyResponse> setDisplayName(String displayName) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        DisplayName request = new DisplayName();
        request.setDisplayName(displayName);
        return this.profileApi.setDisplayName(userId, request).toCompletableFuture();
    }

    public CompletableFuture<DisplayName> showDisplayName(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.profileApi.showDisplayName(userId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> setAvaterUrl(String avatarUrl) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        AvatarUrl request = new AvatarUrl();
        request.setAvatarUrl(avatarUrl);
        return this.profileApi.setAvatarUrl(userId, request).toCompletableFuture();
    }

    public CompletableFuture<AvatarUrl> showAvatarUrl(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.profileApi.showAvatarUrl(userId).toCompletableFuture();
    }

    public CompletableFuture<Profile> profile(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.profileApi.profile(userId).toCompletableFuture();
    }
}

