/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import io.github.ma1uta.matrix.protocol.ProtocolUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/thirdparty")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ThirdPartyProtocolApi {
    @Operation(summary="Fetches the overall metadata about protocols supported by the homeserver.Includes both the available protocols and all fields required for queries against each protocol.", responses={@ApiResponse(responseCode="200", description="The protocols supported by the homeserver.", content={@Content(schema=@Schema(implementation=Map.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Third party protocols"})
    @GET
    @Secured
    @Path(value="/protocols")
    public void protocols(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3);

    @Operation(summary="Fetches the metadata from the homeserver about a particular third party protocol.", responses={@ApiResponse(responseCode="200", description="The protocol was found and metadata returned.", content={@Content(schema=@Schema(implementation=Protocol.class))}), @ApiResponse(responseCode="404", description="The protocol is unknown.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Third party protocols"})
    @GET
    @Secured
    @Path(value="/protocol/{protocol}")
    public void protocol(@Parameter(description="the name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Requesting this endpoint with a valid protocol name results in a list of successful mapping resultsin a JSON array.", description="Each result contains objects to represent the Matrix room or rooms that represent a portal to this third party network. Each has the Matrix room alias string, an identifier for the particular third party network protocol, and an object containing the network-specific fields that comprise this identifier.It should attempt to canonicalise the identifier as much as reasonably possible given the network type.", responses={@ApiResponse(responseCode="200", description="At least one portal room was found.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolLocation.class)))}), @ApiResponse(responseCode="404", description="No portal rooms were found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Third party protocols"})
    @GET
    @Secured
    @Path(value="/location/{protocol}")
    public void locationProtocol(@Parameter(description="The protocol used to communicate to the third party network.", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve a Matrix User ID linked to a user on the third party service, given a set of user parameters.", responses={@ApiResponse(responseCode="200", description="The Matrix User IDs found with the given parameters.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolUser.class)))}), @ApiResponse(responseCode="404", description="The Matrix User ID was not found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Third party protocols"})
    @GET
    @Secured
    @Path(value="/user/{protocol}")
    public void userProtocol(@Parameter(description="The name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve an array of third party network locations from a Matrix room alias.", responses={@ApiResponse(responseCode="200", description="At least one portal room was found.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolLocation.class)))}), @ApiResponse(responseCode="404", description="No portal rooms were found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Third party protocols"})
    @GET
    @Secured
    @Path(value="/location")
    public void location(@Parameter(description="The Matrix room alias to look up", required=true) @QueryParam(value="alias") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve an array of third party users from a Matrix User ID.", responses={@ApiResponse(responseCode="200", description="The Matrix User IDs found with the given parameters.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolUser.class)))}), @ApiResponse(responseCode="404", description="The Matrix User ID was not found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Third party protocols"})
    @GET
    @Secured
    @Path(value="/user")
    public void user(@Parameter(description="The Matrix User Id to look up", required=true) @QueryParam(value="userid") Id var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

