/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.device.Device;
import io.github.ma1uta.matrix.client.model.device.DeviceDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DeviceUpdateRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface DeviceApi {
    @Operation(summary="Gets information about all devices for the current user.", responses={@ApiResponse(responseCode="200", description="A list of all registered devices for this user.", content={@Content(schema=@Schema(implementation=DevicesResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/devices")
    public void devices(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="Gets information on a single device, by device id.", responses={@ApiResponse(responseCode="200", description="Device information.", content={@Content(schema=@Schema(implementation=Device.class))}), @ApiResponse(responseCode="404", description="The current user has no device with the given ID.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/devices/{deviceId}")
    public void device(@Parameter(description="The device to retrieve", required=true) @PathParam(value="deviceId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Updates the metadata on the given device.", responses={@ApiResponse(responseCode="200", description="The device was successfully updated.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="404", description="The current user has no device with the given ID.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @PUT
    @Secured
    @Path(value="/devices/{deviceId}")
    public void updateDevice(@Parameter(description="The device to update.", required=true) @PathParam(value="deviceId") String var1, @RequestBody(description="The new display name for this device. If not given, the display name is unchanged.") DeviceUpdateRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Deletes the given device, and invalidates any access token associated with it.", description="This API endpoint uses the User-Interactive Authentication API.", responses={@ApiResponse(responseCode="200", description="The device was successfully removed, or had been removed previously.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver requires additional authentication information.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @DELETE
    @Secured
    @Path(value="/devices/{deviceId}")
    public void deleteDevice(@Parameter(description="The device to delete", required=true) @PathParam(value="deviceId") String var1, @RequestBody(description="Additional authentication information for the user-interactive authentication API.") DeviceDeleteRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Deletes the given devices, and invalidates any access token associated with them.", description="This API endpoint uses the User-Interactive Authentication API.", responses={@ApiResponse(responseCode="200", description="The devices were successfully removed, or had been removed previously.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver requires additional authentication information.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @POST
    @Secured
    @Path(value="/delete_devices")
    public void deleteDevices(@RequestBody(description="JSON body request") DevicesDeleteRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);
}

