/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.Event;
import io.github.ma1uta.matrix.client.model.room.Invite3pid;
import io.github.ma1uta.matrix.events.RoomPowerLevels;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="JSON body request for creation api.")
public class CreateRoomRequest {
    @ApiModelProperty(value="A public visibility indicates that the room will be shown in the published room list. A private visibility will hide the room from the published room list. Rooms default to private visibility if this key is not included. NB: This should not be confused with join_rules which also uses the word public.", allowableValues="public, private")
    private String visibility;
    @ApiModelProperty(name="room_alias_name", value="The desired room alias local part. If this is included, a room alias will be created and mapped to the newly created room. The alias will belong on the same homeserver which created the room. For example, if this was set to \"foo\" and sent to the homeserver \"example.com\" the complete room alias would be #foo:example.com.")
    @JsonProperty(value="room_alias_name")
    private String roomAliasName;
    @ApiModelProperty(value="If this is included, an m.room.name event will be sent into the room to indicate the name of the room. See Room Events for more information on m.room.name.")
    private String name;
    @ApiModelProperty(value="If this is included, an m.room.topic event will be sent into the room to indicate the topic for the room. See Room Events for more information on m.room.topic.")
    private String topic;
    @ApiModelProperty(value="A list of user IDs to invite to the room. This will tell the server to invite everyone in the list to the newly created room.")
    private List<String> invite;
    @ApiModelProperty(name="invite_3pid", value="A list of objects representing third party IDs to invite into the room.")
    @JsonProperty(value="invite_3pid")
    private List<Invite3pid> invite3pid;
    @ApiModelProperty(notes="room_version", value="The room version to set for the room. If not provided, the homeserver is to use its configured default. If provided, the homeserver will return a 400 error with the errcode M_UNSUPPORTED_ROOM_VERSION if it does not support the room version.")
    @JsonProperty(value="room_version")
    private String roomVersion;
    @ApiModelProperty(name="creation_content", value="Extra keys to be added to the content of the m.room.create. The server will clobber the following keys: creator. Future versions of the specification may allow the server to clobber other keys.")
    @JsonProperty(value="creation_content")
    private Object creationContent;
    @ApiModelProperty(name="initial_event", value="A list of state events to set in the new room. This allows the user to override the default state events set in the new room. The expected format of the state events are an object with type, state_key and content keys set.")
    @JsonProperty(value="initial_event")
    private List<Event> initialEvent;
    @ApiModelProperty(value="Convenience parameter for setting various default state events based on a preset.", allowableValues="private_chat, public_chat, trusted_private_chat")
    private String preset;
    @ApiModelProperty(name="is_direct", value="This flag makes the server set the is_direct flag on the m.room.member events sent to the users in invite and invite_3pid. See Direct Messaging for more information.")
    @JsonProperty(value="is_direct")
    private Boolean isDirect;
    @ApiModelProperty(name="power_level_content_override", value="The power level content to override in the default power level event. This object is applied on top of the generated m.room.power_levels event content prior to it being sent to the room. Defaults to overriding nothing.")
    @JsonProperty(value="power_level_content_override")
    private RoomPowerLevels powerLevelContentOverride;

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getRoomAliasName() {
        return this.roomAliasName;
    }

    public void setRoomAliasName(String roomAliasName) {
        this.roomAliasName = roomAliasName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public List<String> getInvite() {
        return this.invite;
    }

    public void setInvite(List<String> invite) {
        this.invite = invite;
    }

    public List<Invite3pid> getInvite3pid() {
        return this.invite3pid;
    }

    public void setInvite3pid(List<Invite3pid> invite3pid) {
        this.invite3pid = invite3pid;
    }

    public String getRoomVersion() {
        return this.roomVersion;
    }

    public void setRoomVersion(String roomVersion) {
        this.roomVersion = roomVersion;
    }

    public Object getCreationContent() {
        return this.creationContent;
    }

    public void setCreationContent(Object creationContent) {
        this.creationContent = creationContent;
    }

    public List<Event> getInitialEvent() {
        return this.initialEvent;
    }

    public void setInitialEvent(List<Event> initialEvent) {
        this.initialEvent = initialEvent;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public Boolean getDirect() {
        return this.isDirect;
    }

    public void setDirect(Boolean direct) {
        this.isDirect = direct;
    }

    public RoomPowerLevels getPowerLevelContentOverride() {
        return this.powerLevelContentOverride;
    }

    public void setPowerLevelContentOverride(RoomPowerLevels powerLevelContentOverride) {
        this.powerLevelContentOverride = powerLevelContentOverride;
    }
}

