/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.PusherData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Pusher. A pusher is a worker on the homeserver that manages the sending of HTTP notifications for a user. A user can have multiple pushers: one per device.")
public class Pusher {
    @ApiModelProperty(value="This is a unique identifier for this pusher. See /set for more detail. Max length, 512 bytes.")
    private String pushkey;
    @ApiModelProperty(value="The kind of pusher. \"http\" is a pusher that sends HTTP pokes.")
    private String kind;
    @ApiModelProperty(name="app_id", value="This is a reverse-DNS style identifier for the application. Max length, 64 chars.")
    @JsonProperty(value="app_id")
    private String appId;
    @ApiModelProperty(name="app_display_name", value="A string that will allow the user to identify what application owns this pusher.")
    @JsonProperty(value="app_display_name")
    private String appDisplayName;
    @ApiModelProperty(name="device_display_name", value="A string that will allow the user to identify what device owns this pusher.")
    @JsonProperty(value="device_display_name")
    private String deviceDisplayName;
    @ApiModelProperty(name="profile_tag", value="This string determines which set of device specific rules this pusher executes.")
    @JsonProperty(value="profile_tag")
    private String profileTag;
    @ApiModelProperty(value="The preferred language for receiving notifications (e.g. 'en' or 'en-US')")
    private String lang;
    @ApiModelProperty(value="A dictionary of information for the pusher implementation itself.")
    private PusherData data;

    public String getPushkey() {
        return this.pushkey;
    }

    public void setPushkey(String pushkey) {
        this.pushkey = pushkey;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppDisplayName() {
        return this.appDisplayName;
    }

    public void setAppDisplayName(String appDisplayName) {
        this.appDisplayName = appDisplayName;
    }

    public String getDeviceDisplayName() {
        return this.deviceDisplayName;
    }

    public void setDeviceDisplayName(String deviceDisplayName) {
        this.deviceDisplayName = deviceDisplayName;
    }

    public String getProfileTag() {
        return this.profileTag;
    }

    public void setProfileTag(String profileTag) {
        this.profileTag = profileTag;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public PusherData getData() {
        return this.data;
    }

    public void setData(PusherData data) {
        this.data = data;
    }
}

