/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.Page;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.sync.SyncResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Sync", description="To read events, the intended flow of operation is for clients to first call the /sync API without a since parameter. This returns the most recent message events for each room, as well as the state of the room at the start of the returned timeline. The response also includes a next_batch field, which should be used as the value of the since parameter in the next call to /sync. Finally, the response includes, for each room, a prev_batch field, which can be passed as a start parameter to the /rooms/<room_id>/messages API to retrieve earlier messages.")
@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface SyncApi {
    @ApiOperation(value="Synchronise the client's state with the latest state on the server. Clients use this API when they first log in to get an initial snapshot of the state on the server, and then continue to call this API to get incremental deltas to the state, and to receive new messages.", response=SyncResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The initial snapshot or delta for the client to use to update their state.")})
    @GET
    @Secured
    @Path(value="/sync")
    public void sync(@ApiParam(value="The ID of a filter created using the filter API or a filter JSON object encoded as a string. The server will detect whether it is an ID or a JSON object by whether the first character is a \"{\" open brace. Passing the JSON inline is best suited to one off requests. Creating a filter using the filter API is recommended for clients that reuse the same filter multiple times, for example in long poll requests.") @QueryParam(value="filter") String var1, @ApiParam(value="A point in time to continue a sync from.") @QueryParam(value="since") String var2, @ApiParam(value="Controls whether to include the full state for all rooms the user is a member of.") @QueryParam(value="full_state") Boolean var3, @ApiParam(value="Controls whether the client is automatically marked as online by polling this API. If this parameter is omitted then the client is automatically marked as online when it uses this API. Otherwise if the parameter is set to \"offline\" then the client is not marked as being online when it uses this API.", allowableValues="offline") @QueryParam(value="set_presence") String var4, @ApiParam(value="The maximum time to wait, in milliseconds, before returning this request. If no events (or other data) become available before this time elapses, the server will return a response with empty fields.") @QueryParam(value="timeout") Long var5, @Context HttpServletRequest var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);

    @ApiOperation(value="This will listen for new events related to a particular room and return them to the caller. This will block until an event is received, or until the timeout is reached.", response=Page.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The events received, which may be none."), @ApiResponse(code=400, message="Bad pagination from parameter.")})
    @GET
    @Secured
    @Path(value="/events")
    public void events(@ApiParam(value="The token to stream from. This token is either from a previous request to this API or from the initial sync API.") @QueryParam(value="from") String var1, @ApiParam(value="The maximum time in milliseconds to wait for an event.") @QueryParam(value="timeout") Long var2, @ApiParam(value="The room ID for which events should be returned.") @QueryParam(value="room_id") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    public static class Presence {
        public static final String OFFLINE = "offline";

        protected Presence() {
        }
    }
}

