/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.receipt.ReadMarkersRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Receipt", description="This module adds in support for receipts. These receipts are a form of acknowledgement of an event. This module defines a single acknowledgement: m.read which indicates that the user has read up to a given event.")
@Path(value="/_matrix/client/r0/rooms")
@Produces(value={"application/json"})
public interface ReceiptApi {
    @ApiOperation(value="This API updates the marker for the given receipt type to the event ID specified.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The receipt was sent."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/{roomId}/receipt/{receiptType}/{eventId}")
    public void receipt(@ApiParam(value="The room in which to send the event.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The type of receipt to send.", required=true, allowableValues="m.read") @PathParam(value="receiptType") String var2, @ApiParam(value="The event ID to acknowledge up to.", required=true) @PathParam(value="eventId") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="Sets the position of the read marker for a given room, and optionally the read receipt's location.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The read marker, and read receipt if provided, have been updated."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @Secured
    @RateLimit
    @Path(value="/{roomId}/read_markers")
    public void readMarkers(@ApiParam(value="The room ID to set the read marker in for the user.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="JSON body request.") ReadMarkersRequest var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    public static class Receipt {
        public static final String READ = "m.read";

        protected Receipt() {
        }
    }
}

