/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.push.NotificationResponse;
import io.github.ma1uta.matrix.client.model.push.PushActions;
import io.github.ma1uta.matrix.client.model.push.PushEnable;
import io.github.ma1uta.matrix.client.model.push.PushRule;
import io.github.ma1uta.matrix.client.model.push.PushRulesResponse;
import io.github.ma1uta.matrix.client.model.push.PushUpdateRequest;
import io.github.ma1uta.matrix.client.model.push.PushersRequest;
import io.github.ma1uta.matrix.client.model.push.PushersResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Push", description="This module adds support for push notifications. Homeservers send notifications of events to user-configured HTTP endpoints. Users may also configure a number of rules that determine which events generate notifications. These are all stored and managed by the user's homeserver. This allows user-specific push settings to be reused between client applications.")
@Path(value="/_matrix/client/r0")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface PushApi {
    @ApiOperation(value="Gets all currently active pushers for the authenticated user.", response=PushersResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The pushers for this user.")})
    @GET
    @Secured
    @Path(value="/pushers")
    public void showPushers(@Context HttpServletRequest var1, @Suspended AsyncResponse var2, @Context SecurityContext var3);

    @ApiOperation(value="This endpoint allows the creation, modification and deletion of pushers for this user ID. The behaviour of this endpoint varies depending on the values in the JSON body.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The pusher was set."), @ApiResponse(code=400, message="One or more of the pusher values were invalid."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/pushers/set")
    public void setPushers(@ApiParam(value="JSON body request") PushersRequest var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="This API is used to paginate through the list of events that the user has been, or would have been notified about.", response=NotificationResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="A batch of events is being returned.")})
    @GET
    @Secured
    @Path(value="/notifications")
    public void notifications(@ApiParam(value="Pagination token given to retrieve the next set of events.") @QueryParam(value="from") String var1, @ApiParam(value="Allows basic filtering of events returned.") @QueryParam(value="only") String var2, @ApiParam(value="Limit on the number of events to return in this request.") @QueryParam(value="limit") Long var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="Retrieve all push rulesets for this user. Clients can \"drill-down]\"on the rulesets by suffixing a scope to this path e.g. /pushrules/global/. This will return a subset of this data under the specified key e.g. the global key.", response=PushRulesResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="All the push rulesets for this user.")})
    @GET
    @Secured
    @Path(value="/pushrules")
    public void pushRules(@Context HttpServletRequest var1, @Suspended AsyncResponse var2, @Context SecurityContext var3);

    @ApiOperation(value="Retrieve a single specified push rule.", response=PushRule.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The specific push rule. This will also include keys specific to the rule itself such as the rule's actions and conditions if set.")})
    @GET
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}")
    public void pushRule(@ApiParam(value="Global to specify global rules.", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="This endpoint removes the push rule defined in the path.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The push rule was deleted.")})
    @DELETE
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}")
    public void deleteRule(@ApiParam(value="Global to specify global rules.", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="This endpoint allows the creation, modification and deletion of pushers for this user ID. The behaviour of this endpoint varies depending on the values in the JSON body.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The pusher was set."), @ApiResponse(code=400, message="There was a problem configuring this push rule."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}")
    public void updateRule(@ApiParam(value="Global to specify global rules.", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @ApiParam(value="Use 'before' with a rule_id as its value to make the new rule the next-most important rule with respect to the given user defined rule. It is not possible to add a rule relative to a predefined server rule.") @QueryParam(value="before") String var4, @ApiParam(value="This makes the new rule the next-less important rule relative to the given user defined rule. It is not possible to add a rule relative to a predefined server rule.") @QueryParam(value="after") String var5, @ApiParam(value="JSON body request.") PushUpdateRequest var6, @Context HttpServletRequest var7, @Suspended AsyncResponse var8, @Context SecurityContext var9);

    @ApiOperation(value="This endpoint gets whether the specified push rule is enabled.", response=PushEnable.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="Whether the push rule is enabled.")})
    @GET
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/enabled")
    public void getEnabled(@ApiParam(value="Either global or device/&lt;profile_tag&gt; to specify global rules or device rules for the given profile_tag.", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="his endpoint allows clients to enable or disable the specified push rule.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The push rule was enabled or disabled.")})
    @PUT
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/enabled")
    public void setEnabled(@ApiParam(value="Global to specify global rules", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @ApiParam(value="JSON body request.") PushEnable var4, @Context HttpServletRequest var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @ApiOperation(value="This endpoint get the actions for the specified push rule.", response=PushActions.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The actions for this push rule.")})
    @GET
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/actions")
    public void getActions(@ApiParam(value="Either global or device/&lt;profile_tag&gt; to specify global rules or device rules for the given profile_tag.", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="This endpoint allows clients to change the actions of a push rule. This can be used to change the actions of builtin rules.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The actions for the push rule were set.")})
    @PUT
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/actions")
    public void setActions(@ApiParam(value="Global to specify global rules", required=true) @PathParam(value="scope") String var1, @ApiParam(value="The kind of rule.", required=true, allowableValues="override, underride, sender, room, content") @PathParam(value="kind") String var2, @ApiParam(value="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @ApiParam(value="JSON body request.") PushActions var4, @Context HttpServletRequest var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    public static class Condition {
        public static final String EVENT_MATCH = "event_match";
        public static final String CONTAINS_DISPLAY_NAME = "contains_display_name";
        public static final String ROOM_MEMBER_COUNT = "room_member_count";
        public static final String SENDER_NOTIFICATION_PERMISSION = "sender_notification_permission";

        protected Condition() {
        }
    }

    public static class Rule {
        public static final String MASTER = ".m.rule.master";
        public static final String SUPPRESS_NOTICES = ".m.rule.suppress_notices";
        public static final String INVITE_FOR_ME = ".m.rule.invite_for_me";
        public static final String MEMBER_EVENT = ".m.rule.member_event";
        public static final String CONTAINS_DISPLAY_NAME = ".m.rule.contains_display_name";
        public static final String ROOM_NOTIF = ".m.rule.roomnotif";
        public static final String CONTAINS_USER_NAME = ".m.rule.contains_user_name";
        public static final String CALL = ".m.rule.call";
        public static final String ENCRYPTED_ROOM_ONE_TO_ONE = ".m.rule.encrypted_room_one_to_one";
        public static final String ROOM_ONE_TO_ONE = ".m.rule.room_one_to_one";
        public static final String MESSAGE = ".m.rule.message";
        public static final String ENCRYPTED = ".m.rule.encrypted";

        protected Rule() {
        }
    }

    public static class Tweak {
        public static final String SOUND = "sound";
        public static final String HIGHLIGHT = "highlight";

        protected Tweak() {
        }
    }

    public static class Actions {
        public static final String NOTIFY = "notify";
        public static final String DONT_NOTIFY = "dont_notify";
        public static final String COALESCE = "coalesce";
        public static final String SET_TWEAK = "set_tweak";

        protected Actions() {
        }
    }

    public static class Kind {
        public static final String OVERRIDE = "override";
        public static final String UNDERRIDE = "underride";
        public static final String SENDER = "sender";
        public static final String ROOM = "room";
        public static final String CONTENT = "content";

        protected Kind() {
        }
    }
}

