/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.openid.OpenIdResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="OpenID", description="This module allows users to verify their identity with a third party service. The third party service does need to be matrix-aware in that it will need to know to resolve matrix homeservers to exchange the user's token for identity information.")
@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface OpenIdApi {
    @ApiOperation(value="Gets an OpenID token object that the requester may supply to another service to verify their identity in Matrix.", notes="The generated token is only valid for exchanging for user information from the federation API for OpenID. The access token generated is only valid for the OpenID API. It cannot be used to request another OpenID access token or call /sync, for example.", response=OpenIdResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="OpenID token information. This response is nearly compatible with the response documented in the OpenID 1.0 Specification with the only difference being the lack of an id_token. Instead, the Matrix homeserver's name is provided."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @Secured
    @RateLimit
    @Path(value="/user/{userId}/openid/request_token")
    public void requestToken(@ApiParam(value="The user to request and OpenID token for. Should be the user who is authenticated for the request.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);
}

