/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.encryption.ChangesResponse;
import io.github.ma1uta.matrix.client.model.encryption.ClaimRequest;
import io.github.ma1uta.matrix.client.model.encryption.ClaimResponse;
import io.github.ma1uta.matrix.client.model.encryption.QueryRequest;
import io.github.ma1uta.matrix.client.model.encryption.QueryResponse;
import io.github.ma1uta.matrix.client.model.encryption.UploadRequest;
import io.github.ma1uta.matrix.client.model.encryption.UploadResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Encryption", description="Matrix optionally supports end-to-end encryption, allowing rooms to be created whose conversation contents is not decryptable or interceptable on any of the participating homeservers.")
@Path(value="/_matrix/client/r0/keys")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface EncryptionApi {
    @ApiOperation(value="Publishes end-to-end encryption keys for the device.", response=UploadResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The provided keys were sucessfully uploaded.")})
    @POST
    @Secured
    @Path(value="/upload")
    public void uploadKey(@ApiParam(value="JSON body request") UploadRequest var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Returns the current devices and identity keys for the given users.", response=QueryResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The device information.")})
    @POST
    @Secured
    @Path(value="/query")
    public void query(@ApiParam(value="JSON body request") QueryRequest var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Claims one-time keys for use in pre-key messages.", response=ClaimResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The claimed keys.")})
    @POST
    @Secured
    @Path(value="/claim")
    public void claim(@ApiParam(value="JSON body request.") ClaimRequest var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Gets a list of users who have updated their device identity keys since a previous sync token.", notes="The server should include in the results any users who currently share a room with the calling user (ie, both users have membership state join); and added new device identity keys or removed an existing device with identity keys, between from and to.", response=ChangesResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of users who updated their devices.")})
    @GET
    @Secured
    @Path(value="/changes")
    public void changes(@ApiParam(value="The desired start point of the list. Should be the next_batch field from a response to an earlier call to /sync. Users who have not uploaded new device identity keys since this point, nor deleted existing devices with identity keys since then, will be excluded from the results.", required=true) @QueryParam(value="from") String var1, @ApiParam(value="The desired end point of the list. Should be the next_batch field from a recent call to /sync - typically the most recent such call. This may be used by the server as a hint to check its caches are up to date.", required=true) @QueryParam(value="to") String var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);
}

