/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.client.model.filter.Filter;
import io.github.ma1uta.matrix.client.model.filter.RoomFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="JSON body request for filter api.")
public class FilterData {
    @ApiModelProperty(name="event_fields", value="List of event fields to include. If this list is absent then all fields are included. The entries may include '.' charaters to indicate sub-fields. So ['content.body'] will include the 'body' field of the 'content' object. A literal '.' character in a field name may be escaped using a ''. A server may include more fields than were requested.")
    @JsonProperty(value="event_fields")
    private List<String> eventFields;
    @ApiModelProperty(name="event_format", value="The format to use for events. 'client' will return the events in a format suitable for clients. 'federation' will return the raw event as receieved over federation. The default is 'client'.", allowableValues="['client', 'federation']")
    @JsonProperty(value="event_format")
    private String eventFormat;
    @ApiModelProperty(value="The presence updates to include.")
    private Filter presence;
    @ApiModelProperty(name="account_data", value="The user account data that isn't associated with rooms to include.")
    @JsonProperty(value="account_data")
    private Filter accountData;
    @ApiModelProperty(value="Filters to be applied to room data.")
    private RoomFilter room;

    public List<String> getEventFields() {
        return this.eventFields;
    }

    public void setEventFields(List<String> eventFields) {
        this.eventFields = eventFields;
    }

    public String getEventFormat() {
        return this.eventFormat;
    }

    public void setEventFormat(String eventFormat) {
        this.eventFormat = eventFormat;
    }

    public Filter getPresence() {
        return this.presence;
    }

    public void setPresence(Filter presence) {
        this.presence = presence;
    }

    public Filter getAccountData() {
        return this.accountData;
    }

    public void setAccountData(Filter accountData) {
        this.accountData = accountData;
    }

    public RoomFilter getRoom() {
        return this.room;
    }

    public void setRoom(RoomFilter room) {
        this.room = room;
    }

    public static class EventFormat {
        public static final String CLIENT = "client";
        public static final String FEDERATION = "federation";

        protected EventFormat() {
        }
    }
}

