/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.client.model.eventcontext.EventContextResponse;
import io.github.ma1uta.matrix.common.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/rooms")
@Produces(value={"application/json"})
public interface EventContextApi {
    @Operation(summary="This API returns a number of events that happened just before and after the specified event.", description="This allows clients to get the context surrounding an event.", responses={@ApiResponse(responseCode="200", description="The events and state surrounding the requested event.", content={@Content(schema=@Schema(implementation=EventContextResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/{roomId}/context/{eventId}")
    public void context(@Parameter(description="The room to get events from.", required=true) @PathParam(value="roomId") String var1, @Parameter(description="The event to get context around.", required=true) @PathParam(value="eventId") String var2, @Parameter(description="The maximum number of events to return. Default: 10.") @QueryParam(value="limit") Integer var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);
}

