/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.client.model.encryption.ChangesResponse;
import io.github.ma1uta.matrix.client.model.encryption.ClaimRequest;
import io.github.ma1uta.matrix.client.model.encryption.ClaimResponse;
import io.github.ma1uta.matrix.client.model.encryption.QueryRequest;
import io.github.ma1uta.matrix.client.model.encryption.QueryResponse;
import io.github.ma1uta.matrix.client.model.encryption.UploadRequest;
import io.github.ma1uta.matrix.client.model.encryption.UploadResponse;
import io.github.ma1uta.matrix.common.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/keys")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface EncryptionApi {
    @Operation(summary="Publishes end-to-end encryption keys for the device.", responses={@ApiResponse(responseCode="200", description="The provided keys were sucessfully uploaded.", content={@Content(schema=@Schema(implementation=UploadResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"End-to-end encryption"})
    @POST
    @Secured
    @Path(value="/upload")
    public void uploadKey(@RequestBody(description="JSON body request") UploadRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Returns the current devices and identity keys for the given users.", responses={@ApiResponse(responseCode="200", description="The device information.", content={@Content(schema=@Schema(implementation=QueryResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"End-to-end encryption"})
    @POST
    @Secured
    @Path(value="/query")
    public void query(@RequestBody(description="JSON body request") QueryRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Claims one-time keys for use in pre-key messages.", responses={@ApiResponse(responseCode="200", description="The claimed keys.", content={@Content(schema=@Schema(implementation=ClaimResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"End-to-end encryption"})
    @POST
    @Secured
    @Path(value="/claim")
    public void claim(@RequestBody(description="JSON body request.") ClaimRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Gets a list of users who have updated their device identity keys since a previous sync token.", description="The server should include in the results any users who currently share a room with the calling user (ie, both users have membership state join); and added new device identity keys or removed an existing device with identity keys, between from and to.", responses={@ApiResponse(responseCode="200", description="The list of users who updated their devices.", content={@Content(schema=@Schema(implementation=ChangesResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"End-to-end encryption"})
    @GET
    @Secured
    @Path(value="/changes")
    public void changes(@Parameter(description="The desired start point of the list. Should be the next_batch field from a response to an earlier call to /sync. Users who have not uploaded new device identity keys since this point, nor deleted existing devices with identity keys since then, will be excluded from the results.", required=true) @QueryParam(value="from") String var1, @Parameter(description="The desired end point of the list. Should be the next_batch field from a recent call to /sync - typically the most recent such call. This may be used by the server as a hint to check its caches are up to date.", required=true) @QueryParam(value="to") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);
}

