/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.auth.LoginRequest;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.client.model.auth.SupportedLoginResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface AuthApi {
    @Operation(summary="Gets the homeserver's supported login types to authenticate users.", description="Clients should pick one of these and supply it as the type when logging in.", responses={@ApiResponse(responseCode="200", description="The login types the homeserver supports.", content={@Content(schema=@Schema(implementation=SupportedLoginResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"Session management"})
    @GET
    @RateLimit
    @Path(value="/login")
    public void supportedLoginTypes(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3);

    @Operation(summary="Authenticates the user, and issues an access token they can use to authorize themself in subsequent requests", description="If the client does not supply a device_id, the server must auto-generate one. The returned access token must be associated with the device_id supplied by the client or generated by the server. The server may invalidate any access token previously associated with that device", responses={@ApiResponse(responseCode="200", description="The user has been authenticated", content={@Content(schema=@Schema(implementation=LoginResponse.class))}), @ApiResponse(responseCode="400", description="Part of the request was invalid. For example, the login type may not be recognised", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="The login attempt failed. For example, the password may have been incorrect.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"Session management"})
    @POST
    @RateLimit
    @Path(value="/login")
    public void login(@RequestBody(description="login request.") LoginRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Invalidates an existing access token, so that it can no longer be used for authorization.", responses={@ApiResponse(responseCode="200", description="The access token used in the request was succesfully invalidated", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Session management"})
    @POST
    @Secured
    @Path(value="/logout")
    public void logout(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="Invalidates all access tokens for a user, so that they can no longer be used for authorization. This includes the access token that made this request", description="This endpoint does not require UI authorization because UI authorization is designed to protect against attacks where the someone gets hold of a single access token then takes over the account. This endpoint invalidates all access tokens for the user, including the token used in the request, and therefore the attacker is unable to take over the account in this way.", responses={@ApiResponse(responseCode="200", description="The user's access tokens were succesfully invalidated", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Session management"})
    @POST
    @Secured
    @Path(value="/logout/all")
    public void logoutAll(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    public static class IdentifierType {
        public static final String USER = "m.id.user";
        public static final String THIRD_PARTY = "m.id.thirdparty";
        public static final String PHONE = "m.id.phone";

        protected IdentifierType() {
        }
    }

    public static class AuthType {
        public static final String PASSWORD = "m.login.password";
        public static final String RECAPTCHA = "m.login.recaptcha";
        public static final String OAUTH2 = "m.login.oauth2";
        public static final String SSO = "m.login.sso";
        public static final String EMAIL_IDENTITY = "m.login.email.identity";
        public static final String MSISDN_IDENTITY = "m.login.msisdn";
        public static final String TOKEN = "m.login.token";
        public static final String DUMMY = "m.login.dummy";
        public static final String APPLICATION_SERVICE = "m.login.application_service";

        protected AuthType() {
        }
    }
}

