/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.account.AvailableResponse;
import io.github.ma1uta.matrix.client.model.account.DeactivateRequest;
import io.github.ma1uta.matrix.client.model.account.DeactivateResponse;
import io.github.ma1uta.matrix.client.model.account.Delete3PidRequest;
import io.github.ma1uta.matrix.client.model.account.EmailRequestToken;
import io.github.ma1uta.matrix.client.model.account.MsisdnRequestToken;
import io.github.ma1uta.matrix.client.model.account.PasswordRequest;
import io.github.ma1uta.matrix.client.model.account.RegisterRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidResponse;
import io.github.ma1uta.matrix.client.model.account.UnbindRequest;
import io.github.ma1uta.matrix.client.model.account.WhoamiResponse;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.thirdpid.SessionResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface AccountApi {
    @Operation(summary="Register for an account on this homeserver.", responses={@ApiResponse(responseCode="200", description="The account has been registered", content={@Content(schema=@Schema(implementation=LoginResponse.class))}), @ApiResponse(responseCode="400", description="Part of the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver requires additional authentication information.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"User data"})
    @POST
    @RateLimit
    @Path(value="/register")
    public void register(@Parameter(description="The kind of account to register.", schema=@Schema(allowableValues={"guest", "user"}, defaultValue="user")) @QueryParam(value="kind") String var1, @RequestBody(description="JSON body request.") RegisterRequest var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Request email token.", description="Proxies the identity server API validate/email/emailRequestToken, but first checks that the given email address is not already associated with an account on this Home Server. Note that, for consistency, this API takes JSON objects, though the Identity Server API takes x-www-form-urlencoded parameters. See the Identity Server API for further information.", responses={@ApiResponse(responseCode="200", description="An email has been sent to the specified address.", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="Part of the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The homeserver does not permit the address to be bound.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @POST
    @Path(value="/register/email/requestToken")
    public void emailRequestToken(@RequestBody(description="JSON body request.") EmailRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Request msisdn token.", description="Proxies the Identity Service API validate/msisdn/requestToken, but first checks that the given phone number is not already associated with an account on this homeserver. See the Identity Service API for further information.", responses={@ApiResponse(responseCode="200", description="An SMS message has been sent to the specified phone number.", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="Part of the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The homeserver does not permit the address to be bound.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @POST
    @Path(value="/register/msisdn/requestToken")
    public void msisdnRequestToken(@RequestBody(description="JSON body request.") MsisdnRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Changes the password for an account on this homeserver.", description="This API endpoint uses the User-Interactive Authentication API. An access token should be submitted to this endpoint if the client has an active session. The homeserver may change the flows available depending on whether a valid access token is provided.", responses={@ApiResponse(responseCode="200", description="The password has been changed.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver requires additional authentication information.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @SecurityRequirement(name="Authorization")
    @POST
    @RateLimit
    @Secured
    @Path(value="/account/password")
    public void password(@RequestBody(description="password.") PasswordRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Proxies the identity server API validate/email/requestToken, but first checks that the given email address is associated with an account on this Home Server.", description="This API should be used to request validation tokens when authenticating for the account/password endpoint. This API's parameters and response are identical to that of the HS API /register/email/requestToken except that M_THREEPID_NOT_FOUND may be returned if no account matching the given email address could be found. The server may instead send an email to the given address prompting the user to create an account. M_THREEPID_IN_USE may not be returned.", responses={@ApiResponse(responseCode="200", description="An email was sent to the given address", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="The referenced third party identifier is not recognised by the homeserver, or the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The homeserver does not allow the third party identifier as a contact option.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @POST
    @Path(value="/account/password/email/requestToken")
    public void passwordEmailRequestToken(@RequestBody(description="JSON body request.") EmailRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Proxies the identity server API validate/email/requestToken, but first checks that the given email address is associated with an account on this Home Server.", description="This API should be used to request validation tokens when authenticating for the account/password endpoint. This API's parameters and response are identical to that of the HS API /register/email/requestToken except that M_THREEPID_NOT_FOUND may be returned if no account matching the given email address could be found. The server may instead send an email to the given address prompting the user to create an account. M_THREEPID_IN_USE may not be returned.", responses={@ApiResponse(responseCode="200", description="An SMS message was sent to the given phone number.", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="The referenced third party identifier is not recognised by the homeserver, or the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The homeserver does not allow the third party identifier as a contact option.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @POST
    @Path(value="/account/password/msisdn/requestToken")
    public void passwordMsisdnRequestToken(@RequestBody(description="JSON body request.") MsisdnRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Deactivate the user's account, removing all ability for the user to login again.", description="This API endpoint uses the User-Interactive Authentication API.An access token should be submitted to this endpoint if the client has an active session.The homeserver may change the flows available depending on whether a valid access token is provided.", responses={@ApiResponse(responseCode="200", description="The account has been deactivated.", content={@Content(schema=@Schema(implementation=DeactivateResponse.class))}), @ApiResponse(responseCode="401", description="The homeserver requires additional authentication information.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/account/deactivate")
    public void deactivate(@RequestBody(description="request") DeactivateRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Checks to see if a username is available, and valid, for the server.", description="he server should check to ensure that, at the time of the request, the username requested is available for use.This includes verifying that an application service has not claimed the username and that the username fits the server'sdesired requirements (for example, a server could dictate that it does not permit usernames with underscores).Matrix clients may wish to use this API prior to attempting registration, however the clients must also be awarethat using this API does not normally reserve the username. This can mean that the username becomes unavailablebetween checking its availability and attempting to register it.", responses={@ApiResponse(responseCode="200", description="The username is available.", content={@Content(schema=@Schema(implementation=AvailableResponse.class))}), @ApiResponse(responseCode="400", description="Part of the request was invalid or the username is not available", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"User data"})
    @GET
    @RateLimit
    @Path(value="/register/available")
    public void available(@Parameter(description="The username to check the availability of", required=true) @QueryParam(value="username") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Gets a list of the third party identifiers that the homeserver has associated with the user's account", description="This is not the same as the list of third party identifiers bound to the user's Matrix ID in Identity Servers. Identifiers in this list may be used by the homeserver as, for example, identifiers that it will accept to reset the user's account password.", responses={@ApiResponse(responseCode="200", description="The lookup was successful", content={@Content(schema=@Schema(implementation=ThreePidResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @GET
    @Secured
    @Path(value="/account/3pid")
    public void getThreePid(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="Adds contact information to the user's account", responses={@ApiResponse(responseCode="200", description="The addition was successful.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="403", description="The credentials could not be verified with the identity server.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @POST
    @Secured
    @Path(value="/account/3pid")
    public void updateThreePid(@RequestBody(description="New contact information.") ThreePidRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Removes a third party identifier from the user's account.", description="This might not cause an unbind of the identifier from the identity server.", responses={@ApiResponse(responseCode="200", description="The homeserver has disassociated the third party identifier from the user.", content={@Content(schema=@Schema(implementation=DeactivateResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @POST
    @Secured
    @Path(value="/account/3pid/delete")
    public void deleteThreePid(@RequestBody(description="JSON body request.") Delete3PidRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Removes a third party identifier from the provided identity server without removing it from the homeserver", description="Unlike other endpoints, this endpoint does not take an id_access_token parameter because the homeserver is expected to sign the request to the identity server instead", responses={@ApiResponse(responseCode="200", description="The homeserver has disassociated the third party identifier from the user.", content={@Content(schema=@Schema(implementation=DeactivateResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @POST
    @Secured
    @Path(value="/account/3pid/unbind")
    public void unbind(@RequestBody(description="JSON body request") UnbindRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="Proxies the identity server API validate/email/requestToken", description="Proxies the identity server API validate/email/requestToken, but first checks that the given email address is not already associated with an account on this Home Server. This API should be used to request validation tokens when adding an email address to an account. This API's parameters and response is identical to that of the HS API  /register/email/requestToken endpoint.", responses={@ApiResponse(responseCode="200", description="An email was sent to the given address", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="The third party identifier is already in use on the homeserver, or the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The homeserver does not allow the third party identifier as a contact option.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @POST
    @Path(value="/account/3pid/email/requestToken")
    public void threePidEmailRequestToken(@RequestBody(description="JSON body request.") EmailRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Proxies the identity server API validate/email/requestToken", description="roxies the identity server API validate/email/requestToken, but first checks that the given email address is not already associated with an account on this Home Server. This API should be used to request validation tokens when adding an email address to an account. This API's parameters and response is identical to that of the HS API  /register/email/requestToken endpoint.", responses={@ApiResponse(responseCode="200", description="An SMS message was sent to the given phone number.", content={@Content(schema=@Schema(implementation=SessionResponse.class))}), @ApiResponse(responseCode="400", description="The third party identifier is already in use on the homeserver, or the request was invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The homeserver does not allow the third party identifier as a contact option.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, tags={"User data"})
    @POST
    @Path(value="/account/3pid/msisdn/requestToken")
    public void threePidMsisdnRequestToken(@RequestBody(description="JSON body request.") MsisdnRequestToken var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Gets information about the owner of a given access token", description="Note that, as with the rest of the Client-Server API, Application Services may masquerade as users within their namespace  by giving a user_id query parameter. In this situation, the server should verify that the given user_id is registered by the appservice, and return it in the response body.", responses={@ApiResponse(responseCode="200", description="The token belongs to a known user", content={@Content(schema=@Schema(implementation=WhoamiResponse.class))}), @ApiResponse(responseCode="401", description="The token is not recognised.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The appservice cannot masquerade as the user or has not registered them.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @GET
    @RateLimit
    @Secured
    @Path(value="/account/whoami")
    public void whoami(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    public static class RegisterType {
        public static final String GUEST = "guest";
        public static final String USER = "user";

        protected RegisterType() {
        }
    }
}

