/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ClientConfigApi {
    @Operation(summary="Set some account_data for the client.", description="This config is only visible to the user that set the account_data. The config will be synced to clients in the top-level account_data.", responses={@ApiResponse(responseCode="200", description="The account_data was successfully added.", content={@Content(schema=@Schema(implementation=Map.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @GET
    @Secured
    @Path(value="/{userId}/account_data/{type}")
    public void getConfig(@Parameter(description="The id of the user to get account_data for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @Parameter(description="The event type of the account_data to get. Custom types should be namespaced to avoid clashes.", required=true) @PathParam(value="type") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="Set some account_data for the client.", description="This config is only visible to the user that set the account_data. The config will be synced to clients in the top-level account_data.", responses={@ApiResponse(responseCode="200", description="The account_data was successfully added.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @PUT
    @Secured
    @Path(value="/{userId}/account_data/{type}")
    public void addConfig(@Parameter(description="The id of the user to set account_data for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @Parameter(description="The event type of the account_data to set. Custom types should be namespaced to avoid clashes.", required=true) @PathParam(value="type") String var2, @RequestBody(description="Account data") Map<String, Object> var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Set some account_data for the client on a given room.", description="This config is only visible to the user that set the account_data. The config will be synced to clients in the per-room account_data.", responses={@ApiResponse(responseCode="200", description="The account_data was successfully added.", content={@Content(schema=@Schema(implementation=Map.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @GET
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/account_data/{type}")
    public void getRoomConfig(@Parameter(description="The id of the user to get account_data for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @Parameter(description="The id of the room to get account_data on.", required=true) @PathParam(value="roomId") String var2, @Parameter(description="The event type of the account_data to set. Custom types should be namespaced to avoid clashes.", required=true) @PathParam(value="type") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Set some account_data for the client on a given room.", description="This config is only visible to the user that set the account_data. The config will be synced to clients in the per-room account_data.", responses={@ApiResponse(responseCode="200", description="The account_data was successfully added.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"User data"})
    @PUT
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/account_data/{type}")
    public void addRoomConfig(@Parameter(description="The id of the user to set account_data for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @Parameter(description="The id of the room to set account_data on.", required=true) @PathParam(value="roomId") String var2, @Parameter(description="The event type of the account_data to set. Custom types should be namespaced to avoid clashes.", required=true) @PathParam(value="type") String var3, @RequestBody(description="Account data") Map<String, Object> var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);
}

