/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot.command;

import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.Context;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.event.RoomEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Join<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E>
implements Command<C, D, S, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Join.class);

    @Override
    public String name() {
        return "join";
    }

    @Override
    public boolean invoke(Context<C, D, S, E> context, String roomId, RoomEvent event, String arguments) {
        C config = context.getConfig();
        MatrixClient matrixClient = context.getMatrixClient();
        if (((BotConfig)config).getOwner() != null && !((BotConfig)config).getOwner().equals(event.getSender())) {
            return false;
        }
        if (arguments == null || arguments.trim().isEmpty()) {
            matrixClient.event().sendNotice(roomId, "Usage: " + this.usage());
        } else {
            try {
                RoomId result = (RoomId)matrixClient.room().joinByIdOrAlias(String.valueOf(arguments)).join();
                context.getBot().getSkipTimelineRooms().add(result.getRoomId());
            }
            catch (Exception e) {
                String msg = String.format("Cannot join: %s", e.getMessage());
                LOGGER.error(msg, (Throwable)e);
                matrixClient.event().sendNotice(roomId, msg);
            }
        }
        return true;
    }

    @Override
    public String help() {
        return "join new room (invoked only by owner).";
    }

    @Override
    public String usage() {
        return "join <room id or alias>";
    }
}

