/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.bot.AccessPolicy;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.BotState;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.Context;
import io.github.ma1uta.matrix.bot.LoopState;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.bot.ReceiptPolicy;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.model.account.RegisterRequest;
import io.github.ma1uta.matrix.client.model.filter.FilterData;
import io.github.ma1uta.matrix.client.model.filter.FilterResponse;
import io.github.ma1uta.matrix.client.model.filter.RoomEventFilter;
import io.github.ma1uta.matrix.client.model.filter.RoomFilter;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.RoomEvent;
import io.github.ma1uta.matrix.event.RoomMember;
import io.github.ma1uta.matrix.event.RoomMessage;
import io.github.ma1uta.matrix.event.content.RoomMemberContent;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.event.message.Text;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bot<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bot.class);
    private final Map<String, Command<C, D, S, E>> commands;
    private BiConsumer<Context<C, D, S, E>, D> initAction;
    private Context<C, D, S, E> context;
    private final boolean exitOnEmptyRooms;
    private final Set<String> skipTimelineRooms = new HashSet<String>();

    public Bot(RequestFactory factory, String asToken, boolean exitOnEmptyRooms, C config, S service, List<Class<? extends Command<C, D, S, E>>> commandsClasses) {
        this.context = this.init(factory, asToken, config, service);
        this.exitOnEmptyRooms = exitOnEmptyRooms;
        this.commands = new HashMap<String, Command<C, D, S, E>>(commandsClasses.size());
        commandsClasses.forEach(cl -> {
            try {
                Command command = (Command)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.commands.put(command.name(), command);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Cannot create new instance of the command: " + cl.getCanonicalName(), (Throwable)e);
            }
        });
    }

    protected Context<C, D, S, E> init(RequestFactory factory, String asToken, C config, S service) {
        MatrixClient matrixClient = new MatrixClient(factory, new RequestParams().userId(String.valueOf(((BotConfig)config).getUserId())).accessToken(asToken));
        Context context = new Context(matrixClient, service, this);
        context.setConfig(config);
        return context;
    }

    public void init() {
        Context<C, BotDao, S, E> context = this.getContext();
        C config = context.getConfig();
        context.getMatrixClient().auth().login(((BotConfig)config).getUserId(), ((BotConfig)config).getPassword());
        if (this.getInitAction() != null) {
            context.runInTransaction((ctx, dao) -> this.getInitAction().accept((Context<C, D, S, E>)ctx, (D)dao));
        }
    }

    public Map<String, Command<C, D, S, E>> getCommands() {
        return this.commands;
    }

    public Context<C, D, S, E> getContext() {
        return this.context;
    }

    public BiConsumer<Context<C, D, S, E>, D> getInitAction() {
        return this.initAction;
    }

    public boolean isExitOnEmptyRooms() {
        return this.exitOnEmptyRooms;
    }

    public void setInitAction(BiConsumer<Context<C, D, S, E>, D> initAction) {
        this.initAction = initAction;
    }

    public Set<String> getSkipTimelineRooms() {
        return this.skipTimelineRooms;
    }

    public LoopState newState() {
        this.getContext().runInTransaction((context, dao) -> {
            LOGGER.debug("Start registration.");
            Object config = context.getConfig();
            RegisterRequest registerRequest = new RegisterRequest();
            registerRequest.setUsername((String)Id.localPart((String)((BotConfig)config).getUserId()).orElseThrow(() -> new IllegalArgumentException("Missing bot id.")));
            registerRequest.setInitialDeviceDisplayName(((BotConfig)config).getDisplayName());
            registerRequest.setDeviceId(((BotConfig)config).getDeviceId());
            MatrixClient matrixClient = context.getMatrixClient();
            matrixClient.account().register(registerRequest);
            LOGGER.debug("Set new display name: {}", (Object)((BotConfig)config).getDisplayName());
            matrixClient.profile().setDisplayName(((BotConfig)config).getDisplayName());
            RoomEventFilter roomEventFilter = new RoomEventFilter();
            roomEventFilter.setTypes(Collections.singletonList("m.room.message"));
            RoomFilter roomFilter = new RoomFilter();
            roomFilter.setTimeline(roomEventFilter);
            FilterData filter = new FilterData();
            filter.setRoom(roomFilter);
            ((BotConfig)config).setFilterId(((FilterResponse)matrixClient.filter().uploadFilter(filter).join()).getFilterId());
            LOGGER.debug("Set new filter: {}", (Object)((BotConfig)config).getFilterId());
            ((BotConfig)config).setState(BotState.REGISTERED);
            LOGGER.debug("Finish registration.");
        });
        return LoopState.NEXT_STATE;
    }

    protected LoopState registeredState(Map<String, List<Event>> eventMap) {
        LOGGER.debug("Wait for invite");
        if (!eventMap.isEmpty()) {
            return this.joinRoom(eventMap) ? LoopState.NEXT_STATE : LoopState.RUN;
        }
        return LoopState.RUN;
    }

    public boolean joinRoom(Map<String, List<Event>> eventMap) {
        return this.getContext().runInTransaction((context, dao) -> {
            LOGGER.debug("Start joining.");
            boolean joined = false;
            for (Map.Entry eventEntry : eventMap.entrySet()) {
                List inviteEvents = ((List)eventEntry.getValue()).stream().peek(state -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Event type: {}", (Object)state.getType());
                    }
                }).filter(state -> {
                    if (state instanceof RoomMember) {
                        RoomMember roomMember = (RoomMember)state;
                        String membership = ((RoomMemberContent)roomMember.getContent()).getMembership();
                        LOGGER.debug("Membership: {}", (Object)membership);
                        return "invite".equals(membership);
                    }
                    return false;
                }).collect(Collectors.toList());
                for (Event state2 : inviteEvents) {
                    if (!(state2 instanceof RoomEvent)) continue;
                    String roomId = (String)eventEntry.getKey();
                    LOGGER.debug("Join to room {}", (Object)roomId);
                    context.getMatrixClient().room().joinByIdOrAlias(roomId);
                    Object config = context.getConfig();
                    ((BotConfig)config).setState(BotState.JOINED);
                    ((BotConfig)config).setOwner(((RoomEvent)state2).getSender().toString());
                    LOGGER.debug("Finish joining");
                    joined = true;
                }
            }
            return joined;
        });
    }

    public LoopState deletedState() {
        this.getContext().runInTransaction((context, dao) -> {
            LOGGER.debug("Delete bot");
            context.getMatrixClient().account().deactivate(null);
            dao.delete(context.getConfig());
        });
        return LoopState.EXIT;
    }

    public LoopState processJoinedRoom(String roomId, List<Event> events) {
        String lastEvent = null;
        long lastOriginTs = 0L;
        MatrixClient matrixClient = this.getContext().getMatrixClient();
        boolean invoked = false;
        for (Event event : events) {
            RoomEvent roomEvent;
            if (!this.getSkipTimelineRooms().contains(roomId)) {
                LOGGER.debug("Process events");
                invoked = this.processEvent(roomId, event);
            } else {
                LOGGER.debug("Skip timelines");
            }
            if (!(event instanceof RoomEvent) || (roomEvent = (RoomEvent)event).getOriginServerTs() == null || roomEvent.getOriginServerTs() <= lastOriginTs) continue;
            lastOriginTs = roomEvent.getOriginServerTs();
            lastEvent = roomEvent.getEventId();
        }
        C config = this.getContext().getConfig();
        boolean read = ((BotConfig)config).getReceiptPolicy() == null || ReceiptPolicy.READ.equals((Object)((BotConfig)config).getReceiptPolicy());
        boolean executed = ((BotConfig)config).getReceiptPolicy() != null && ReceiptPolicy.EXECUTED.equals((Object)((BotConfig)config).getReceiptPolicy()) && invoked;
        LOGGER.debug("Read: {}", (Object)read);
        LOGGER.debug("Executed: {}", (Object)executed);
        LOGGER.debug("Last event: {}", lastEvent);
        if (lastEvent != null && (read || executed)) {
            LOGGER.debug("send receipt");
            matrixClient.receipt().sendReceipt(roomId, lastEvent);
        }
        this.getSkipTimelineRooms().remove(roomId);
        return LoopState.RUN;
    }

    protected boolean processEvent(String roomId, Event event) {
        MatrixClient matrixClient = this.getContext().getMatrixClient();
        C config = this.getContext().getConfig();
        boolean invoked = false;
        if (event instanceof RoomMessage) {
            boolean defaultCommand;
            RoomMessage roomMessage = (RoomMessage)event;
            RoomMessageContent content = (RoomMessageContent)roomMessage.getContent();
            String body = content.getBody().trim();
            boolean permit = this.permit(event);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sender: {}", (Object)roomMessage.getSender());
                LOGGER.debug("Msgtype: {}", (Object)content.getMsgtype());
                LOGGER.debug("Permit: {}", (Object)permit);
            }
            boolean bl = defaultCommand = ((BotConfig)config).getDefaultCommand() != null && !((BotConfig)config).getDefaultCommand().trim().isEmpty();
            if (!matrixClient.getUserId().equals(roomMessage.getSender()) && content instanceof Text && permit && (body.startsWith(this.getPrefix()) || defaultCommand)) {
                try {
                    invoked = this.getContext().runInTransaction((context, dao) -> this.processAction(roomId, (RoomEvent)roomMessage, body));
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Cannot perform action '%s'", body), (Throwable)e);
                }
            }
        }
        return invoked;
    }

    protected boolean permit(Event event) {
        C config = this.getContext().getConfig();
        return ((BotConfig)config).getPolicy() == null || AccessPolicy.ALL.equals((Object)((BotConfig)config).getPolicy()) || event instanceof RoomEvent && ((BotConfig)config).getOwner().equals(((RoomEvent)event).getSender().toString());
    }

    public String getPrefix() {
        C config = this.getContext().getConfig();
        String prefix = ((BotConfig)config).getPrefix();
        return prefix == null ? "!" : prefix.replaceAll("\\{\\{display_name}}", ((BotConfig)config).getDisplayName());
    }

    protected boolean processAction(String roomId, RoomEvent event, String content) {
        String contentWithoutPrefix = content.substring(this.getPrefix().length());
        String[] arguments = contentWithoutPrefix.trim().split("\\s");
        String commandName = arguments[0];
        Command<C, D, S, E> command = this.getCommands().get(commandName);
        C config = this.getContext().getConfig();
        String argument = Arrays.stream(arguments).skip(1L).collect(Collectors.joining(" "));
        String defaultCommand = ((BotConfig)config).getDefaultCommand();
        if (command == null && defaultCommand != null && !defaultCommand.trim().isEmpty()) {
            command = this.getCommands().get(defaultCommand);
            argument = content;
        }
        if (command != null) {
            LOGGER.debug("invoke command: {}", command.getClass());
            return command.invoke(this.getContext(), roomId, event, argument);
        }
        this.getContext().getMatrixClient().event().sendNotice(roomId, "Unknown command: " + commandName);
        return false;
    }
}

