/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.bot.AbstractBotPool;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.bot.StandaloneBot;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStandaloneBotPool<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E>
extends AbstractBotPool<C, D, S, E, StandaloneBot<C, D, S, E>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStandaloneBotPool.class);
    private static final int TIMEOUT = 10;
    private final ExecutorService pool = Executors.newCachedThreadPool();

    public AbstractStandaloneBotPool(RequestFactory requestFactory, String displayName, S service, List<Class<? extends Command<C, D, S, E>>> commandClasses) {
        super(requestFactory, displayName, service, commandClasses);
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    @Override
    protected StandaloneBot<C, D, S, E> createBotInstance(C config) {
        return new StandaloneBot(this.getRequestFactory(), true, config, this.getService(), this.getCommandClasses());
    }

    @Override
    protected void submitBot(StandaloneBot<C, D, S, E> bot) {
        this.getPool().submit(bot);
    }

    @Override
    public void stop() throws InterruptedException {
        this.getPool().awaitTermination(10L, TimeUnit.SECONDS);
    }
}

