/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.ui.tvm.widget.media;

import io.github.mmm.ui.api.datatype.media.UiMedia;
import io.github.mmm.ui.api.datatype.media.UiMediaPreview;
import io.github.mmm.ui.api.datatype.media.UiMediaSource;
import io.github.mmm.ui.api.datatype.media.UiMediaTrack;
import io.github.mmm.ui.api.widget.media.UiMediaWidget;
import io.github.mmm.ui.tvm.widget.TvmActiveWidget;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLMediaElement;
import org.teavm.jso.dom.html.HTMLSourceElement;
import org.teavm.jso.dom.xml.Node;

public abstract class TvmMediaWidget<W extends HTMLMediaElement>
extends TvmActiveWidget<W>
implements UiMediaWidget {
    private static final String ATR_POSTER = "poster";
    private UiMedia media;

    public TvmMediaWidget(W widget) {
        super(widget);
    }

    public UiMedia getMedia() {
        return this.media;
    }

    public void setMedia(UiMedia media) {
        this.media = media;
        this.setMedia((HTMLMediaElement)this.widget, media);
    }

    protected void setMedia(HTMLMediaElement mediaElement, UiMedia media) {
        mediaElement.pause();
        TvmMediaWidget.removeAllChildren((Node)mediaElement);
        UiMediaPreview preview = null;
        if (media != null) {
            String language;
            preview = media.getPreview();
            HTMLDocument document = mediaElement.getOwnerDocument();
            for (UiMediaSource source : media.getSources()) {
                HTMLSourceElement sourceElement = (HTMLSourceElement)document.createElement("source").cast();
                sourceElement.setSrc(source.getUrl());
                String mimetype = source.getMimetype();
                if (mimetype != null) {
                    sourceElement.setType(mimetype);
                }
                if ((language = source.getLanguage()) != null) {
                    sourceElement.setLang(language);
                }
                mediaElement.appendChild((Node)sourceElement);
            }
            for (UiMediaTrack track : media.getTracks()) {
                HTMLElement trackElement = document.createElement("track");
                trackElement.setAttribute("src", track.getUrl());
                String kind = track.getKind();
                if (kind != null) {
                    trackElement.setAttribute("kind", kind);
                }
                if ((language = track.getLanguage()) != null) {
                    trackElement.setAttribute("srclang", language);
                }
                mediaElement.appendChild((Node)trackElement);
            }
        }
        if (preview == null) {
            mediaElement.removeAttribute(ATR_POSTER);
        } else {
            mediaElement.setAttribute(ATR_POSTER, preview.getUrl());
        }
        mediaElement.load();
    }

    public boolean isPlaying() {
        if (((HTMLMediaElement)this.widget).isPaused()) {
            return false;
        }
        return !((HTMLMediaElement)this.widget).isEnded();
    }

    public void setPlaying(boolean playing) {
        if (playing) {
            ((HTMLMediaElement)this.widget).play();
        } else {
            ((HTMLMediaElement)this.widget).pause();
        }
    }

    public double getVolume() {
        return ((HTMLMediaElement)this.widget).getVolume();
    }

    public void setVolume(double volume) {
        ((HTMLMediaElement)this.widget).setVolume((float)volume);
    }

    public boolean isMuted() {
        return ((HTMLMediaElement)this.widget).isMuted();
    }

    public void setMuted(boolean mute) {
        ((HTMLMediaElement)this.widget).setMuted(mute);
    }

    public double getPosition() {
        return ((HTMLMediaElement)this.widget).getCurrentTime();
    }

    public void setPosition(double position) {
        ((HTMLMediaElement)this.widget).setCurrentTime(position);
    }

    public double getDuration() {
        double duration = ((HTMLMediaElement)this.widget).getDuration();
        if (!Double.isFinite(duration)) {
            return 0.0;
        }
        return duration;
    }

    protected void setEnabledNative(boolean enabled) {
    }
}

