/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.ui.tvm.widget.media;

import io.github.mmm.ui.api.datatype.media.UiMedia;
import io.github.mmm.ui.api.datatype.media.UiMediaType;
import io.github.mmm.ui.api.widget.media.UiMediaPlayer;
import io.github.mmm.ui.tvm.widget.TvmActiveWidget;
import io.github.mmm.ui.tvm.widget.media.TvmAudioPlayer;
import io.github.mmm.ui.tvm.widget.media.TvmMediaWidget;
import io.github.mmm.ui.tvm.widget.media.TvmVideoPlayer;
import org.teavm.jso.dom.html.HTMLAudioElement;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLVideoElement;
import org.teavm.jso.dom.xml.Node;

public class TvmMediaPlayer
extends TvmActiveWidget<HTMLElement>
implements UiMediaPlayer {
    private TvmAudioPlayer audio;
    private TvmVideoPlayer video;
    private TvmMediaWidget<?> activeMedia;

    public TvmMediaPlayer() {
        super(TvmMediaPlayer.newElement((String)"ui-mplayer"));
    }

    private TvmAudioPlayer getAudio() {
        if (this.audio == null) {
            this.audio = new TvmAudioPlayer();
            ((HTMLAudioElement)this.audio.getWidget()).setControls(true);
            this.getTopWidget().appendChild((Node)this.audio.getTopWidget());
            this.activeMedia = this.audio;
        }
        return this.audio;
    }

    private TvmVideoPlayer getVideo() {
        if (this.video == null) {
            this.video = new TvmVideoPlayer();
            ((HTMLVideoElement)this.video.getWidget()).setControls(true);
            this.getTopWidget().appendChild((Node)this.video.getTopWidget());
            this.activeMedia = this.video;
        }
        return this.video;
    }

    private void activate(UiMediaType type, UiMedia media) {
        TvmMediaWidget newActiveMedia = type == UiMediaType.AUDIO ? this.getAudio() : (type == UiMediaType.VIDEO ? this.getVideo() : null);
        if (this.activeMedia != newActiveMedia) {
            if (this.activeMedia != null) {
                this.activeMedia.setMedia(null);
                this.activeMedia.setVisible(false);
            }
            this.activeMedia = newActiveMedia;
        }
        if (this.activeMedia != null) {
            this.activeMedia.setMedia(media);
            this.activeMedia.setVisible(true);
        }
    }

    public UiMedia getMedia() {
        if (this.activeMedia == null) {
            return null;
        }
        return this.activeMedia.getMedia();
    }

    public void setMedia(UiMedia media) {
        if (media == null) {
            if (this.activeMedia != null) {
                this.activeMedia.setMedia(null);
            }
            return;
        }
        this.activate(media.getType(), media);
    }

    public boolean isPlaying() {
        if (this.activeMedia != null) {
            return this.activeMedia.isPlaying();
        }
        return false;
    }

    public void setPlaying(boolean playing) {
        if (this.activeMedia != null) {
            this.activeMedia.setPlaying(playing);
        }
    }

    public double getVolume() {
        if (this.activeMedia != null) {
            return this.activeMedia.getVolume();
        }
        return 0.0;
    }

    public void setVolume(double volume) {
        if (this.activeMedia != null) {
            this.activeMedia.setVolume(volume);
        }
    }

    public boolean isMuted() {
        if (this.activeMedia != null) {
            return this.activeMedia.isMuted();
        }
        return false;
    }

    public void setMuted(boolean muted) {
        if (this.activeMedia != null) {
            this.activeMedia.setMuted(muted);
        }
    }

    public double getPosition() {
        if (this.activeMedia != null) {
            return this.activeMedia.getPosition();
        }
        return 0.0;
    }

    public void setPosition(double position) {
        if (this.activeMedia != null) {
            this.activeMedia.setPosition(position);
        }
    }

    public double getDuration() {
        if (this.activeMedia != null) {
            return this.activeMedia.getDuration();
        }
        return 0.0;
    }

    protected void setEnabledNative(boolean enabled) {
        if (this.activeMedia != null) {
            this.activeMedia.setEnabled(enabled);
        }
    }
}

