/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.yuv;

import android.media.Image;
import com.rtmpx.library.yuv.YuvFrame;
import java.nio.ByteBuffer;

public class YuvHelper {
    private static YuvFrame mYuvFrame;
    private static ByteBuffer y;
    private static ByteBuffer u;
    private static ByteBuffer v;

    public static YuvFrame createYuvFrame(int width, int height) {
        if (null == mYuvFrame || mYuvFrame.getWidth() != width || mYuvFrame.getHeight() != height) {
            mYuvFrame = new YuvFrame();
            v = null;
            u = null;
            y = null;
        }
        int ySize = width * height;
        int uvSize = width * height / 4;
        if (null == y) {
            y = ByteBuffer.allocateDirect(ySize);
        } else {
            y.clear();
        }
        if (null == u) {
            u = ByteBuffer.allocateDirect(uvSize);
        } else {
            u.clear();
        }
        if (null == v) {
            v = ByteBuffer.allocateDirect(uvSize);
        } else {
            v.clear();
        }
        int extra = width % 2 == 0 ? 0 : 1;
        mYuvFrame.fill(y, u, v, width, width / 2 + extra, width / 2 + extra, width, height);
        return mYuvFrame;
    }

    public static YuvFrame createYuvFrame(int width, int height, int rotationMode) {
        int outWidth = rotationMode == 90 || rotationMode == 270 ? height : width;
        int outHeight = rotationMode == 90 || rotationMode == 270 ? width : height;
        return YuvHelper.createYuvFrame(outWidth, outHeight);
    }

    public static YuvFrame rotate(Image image, int rotationMode) {
        assert (rotationMode == 0 || rotationMode == 90 || rotationMode == 180 || rotationMode == 270);
        YuvFrame outFrame = YuvHelper.createYuvFrame(image.getWidth(), image.getHeight(), rotationMode);
        YuvHelper.rotate(image.getPlanes()[0].getBuffer(), image.getPlanes()[1].getBuffer(), image.getPlanes()[2].getBuffer(), image.getPlanes()[0].getRowStride(), image.getPlanes()[1].getRowStride(), image.getPlanes()[2].getRowStride(), outFrame.getY(), outFrame.getU(), outFrame.getV(), outFrame.getyStride(), outFrame.getuStride(), outFrame.getvStride(), image.getWidth(), image.getHeight(), rotationMode);
        return outFrame;
    }

    public static YuvFrame rotate(YuvFrame yuvFrame, int rotationMode) {
        assert (rotationMode == 0 || rotationMode == 90 || rotationMode == 180 || rotationMode == 270);
        YuvFrame outFrame = YuvHelper.createYuvFrame(yuvFrame.getWidth(), yuvFrame.getHeight(), rotationMode);
        YuvHelper.rotate(yuvFrame.getY(), yuvFrame.getU(), yuvFrame.getV(), yuvFrame.getyStride(), yuvFrame.getuStride(), yuvFrame.getvStride(), outFrame.getY(), outFrame.getU(), outFrame.getV(), outFrame.getyStride(), outFrame.getuStride(), outFrame.getvStride(), yuvFrame.getWidth(), yuvFrame.getHeight(), rotationMode);
        return outFrame;
    }

    public static YuvFrame convertToI420(Image image) {
        YuvFrame outFrame = YuvHelper.createYuvFrame(image.getWidth(), image.getHeight());
        YuvHelper.convertToI420(image.getPlanes()[0].getBuffer(), image.getPlanes()[1].getBuffer(), image.getPlanes()[2].getBuffer(), image.getPlanes()[0].getRowStride(), image.getPlanes()[1].getRowStride(), image.getPlanes()[2].getRowStride(), image.getPlanes()[2].getPixelStride(), outFrame.getY(), outFrame.getU(), outFrame.getV(), outFrame.getyStride(), outFrame.getuStride(), outFrame.getvStride(), image.getWidth(), image.getHeight());
        return outFrame;
    }

    public static YuvFrame convertToI420(YuvFrame yuvFrame, int uvPixelStride) {
        YuvFrame outFrame = YuvHelper.createYuvFrame(yuvFrame.getWidth(), yuvFrame.getHeight());
        YuvHelper.convertToI420(yuvFrame.getY(), yuvFrame.getU(), yuvFrame.getV(), yuvFrame.getyStride(), yuvFrame.getuStride(), yuvFrame.getvStride(), uvPixelStride, outFrame.getY(), outFrame.getU(), outFrame.getV(), outFrame.getyStride(), outFrame.getuStride(), outFrame.getvStride(), yuvFrame.getWidth(), yuvFrame.getHeight());
        return outFrame;
    }

    public static native void rotate(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, int var3, int var4, int var5, ByteBuffer var6, ByteBuffer var7, ByteBuffer var8, int var9, int var10, int var11, int var12, int var13, int var14);

    public static native void convertToI420(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, int var3, int var4, int var5, int var6, ByteBuffer var7, ByteBuffer var8, ByteBuffer var9, int var10, int var11, int var12, int var13, int var14);

    public static native void I420ToNV12(byte[] var0, int var1, int var2, byte[] var3);

    static {
        System.loadLibrary("rtmpx");
    }
}

