/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.record.audio;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.rtmpx.library.publish.RTMPPublisher;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioRecorder
implements Handler.Callback {
    private static final String TAG = "AudioRecorder";
    private static final int MSG_START_RECORD = 65297;
    private OnAudioRecordListener mAudioRecordListener;
    private AudioRecord mAudioRecorder;
    private HandlerThread mAudioRecordThread;
    private Handler mAudioRecordHandler;
    private byte[] mBuffer;
    private AtomicBoolean mRecordStarted = new AtomicBoolean(false);

    public AudioRecorder(byte[] mBuffer) {
        this.mBuffer = mBuffer;
        this.initAudioRecord();
    }

    public void setAudioRecordListener(OnAudioRecordListener mAudioRecordListener) {
        this.mAudioRecordListener = mAudioRecordListener;
    }

    private void initAudioRecord() {
        if (null == this.mAudioRecorder) {
            int audioSource = 1;
            int sampleRate = 44100;
            int channelConfig = 12;
            int audioFormat = 2;
            int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
            this.mAudioRecorder = new AudioRecord(audioSource, sampleRate, channelConfig, audioFormat, Math.max(minBufferSize, this.mBuffer.length));
        }
    }

    private void sendStartRecordMessage() {
        if (null == this.mAudioRecordThread || !this.mAudioRecordThread.isAlive() || this.mAudioRecordThread.isInterrupted()) {
            this.mAudioRecordThread = new HandlerThread("AudioRecord"){

                protected void onLooperPrepared() {
                    super.onLooperPrepared();
                    AudioRecorder.this.mAudioRecordHandler = new Handler(this.getLooper(), (Handler.Callback)AudioRecorder.this);
                    AudioRecorder.this.mAudioRecordHandler.obtainMessage(65297).sendToTarget();
                }
            };
            this.mAudioRecordThread.start();
        } else {
            this.mAudioRecordHandler.obtainMessage(65297).sendToTarget();
        }
    }

    private void startRecordPcm() {
        this.initAudioRecord();
        try {
            this.mAudioRecorder.startRecording();
            this.mRecordStarted.set(true);
            while (this.mRecordStarted.get()) {
                int read = this.mAudioRecorder.read(this.mBuffer, 0, this.mBuffer.length);
                if (read <= 0) {
                    Thread.sleep(10L);
                    continue;
                }
                if (null == this.mAudioRecordListener || !RTMPPublisher.getInstance().isWorked()) continue;
                this.mAudioRecordListener.onAudioRecord(this.mBuffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendStopRecordMessage() {
        this.stopRecordPcm();
    }

    private void stopRecordPcm() {
        this.mRecordStarted.set(false);
        if (this.mAudioRecorder != null) {
            try {
                this.mAudioRecorder.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != this.mAudioRecordHandler) {
            this.mAudioRecordHandler.removeCallbacksAndMessages(null);
            this.mAudioRecordHandler = null;
        }
        if (null != this.mAudioRecordThread) {
            try {
                this.mAudioRecordThread.quit();
                this.mAudioRecordThread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mAudioRecordThread = null;
            }
        }
    }

    public void startRecord() {
        this.sendStartRecordMessage();
    }

    public void stopRecord() {
        this.sendStopRecordMessage();
    }

    public void release() {
        if (null != this.mAudioRecorder) {
            this.mAudioRecorder.release();
            this.mAudioRecorder = null;
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 65297: {
                this.startRecordPcm();
            }
        }
        return false;
    }

    public static interface OnAudioRecordListener {
        public void onAudioRecord(byte[] var1);

        public void onAudioRecordError(String var1);
    }
}

