/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.publish;

import android.util.Log;
import androidx.camera.core.ImageProxy;
import com.rtmpx.library.camera.ICamera;
import com.rtmpx.library.camera.ICameraPreviewCallback;
import com.rtmpx.library.config.Config;
import com.rtmpx.library.publish.IPublishListener;
import com.rtmpx.library.publish.RTMPPublisher;
import com.rtmpx.library.record.audio.AudioRecorder;
import com.rtmpx.library.utils.ConvertUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class PublisherX
extends ICameraPreviewCallback
implements AudioRecorder.OnAudioRecordListener {
    private static final String TAG = "PublisherX";
    private byte[] mBuff = new byte[2048];
    private Config mConfig;
    private ICamera mCamera;
    private AudioRecorder mAudioRecorder = new AudioRecorder(this.mBuff);
    private AtomicBoolean mPublishing = new AtomicBoolean(false);

    public PublisherX(Config mConfig, ICamera mCamera) {
        this.mConfig = mConfig;
        this.bindCamera(mCamera);
    }

    public PublisherX(Config mConfig) {
        this.mConfig = mConfig;
    }

    public void bindCamera(ICamera mCamera) {
        this.mCamera = mCamera;
        this.mCamera.setPreviewCallback(this);
        this.mAudioRecorder.setAudioRecordListener(this);
    }

    public void setPublishListener(IPublishListener mPublishListener) {
        RTMPPublisher.getInstance().setPublishListener(mPublishListener);
    }

    public void startPublish() {
        if (this.mPublishing.get()) {
            Log.d((String)TAG, (String)"is publishing no handle startPublish");
            return;
        }
        this.mAudioRecorder.startRecord();
        RTMPPublisher.getInstance().startPublish(this.mConfig);
        this.mPublishing.set(true);
    }

    public void stopPublish() {
        if (!this.mPublishing.get()) {
            Log.d((String)TAG, (String)"not  publishing no handle stopPublish");
            return;
        }
        RTMPPublisher.getInstance().stopPublish();
        if (null != this.mAudioRecorder) {
            this.mAudioRecorder.stopRecord();
        }
        this.mPublishing.set(false);
    }

    public void release() {
        if (null != this.mAudioRecorder) {
            this.mAudioRecorder.setAudioRecordListener(null);
            this.mAudioRecorder.release();
        }
        RTMPPublisher.getInstance().setPublishListener(null);
    }

    @Override
    public void onAudioRecord(byte[] pcm) {
        if (!RTMPPublisher.getInstance().isWorked()) {
            Log.d((String)TAG, (String)"rtmp not  worked  no handle onAudioRecord");
            return;
        }
        RTMPPublisher.getInstance().encodeAudio(pcm);
    }

    @Override
    public void onAudioRecordError(String message) {
        Log.d((String)TAG, (String)("onAudioRecordError message is " + message));
    }

    @Override
    public void handleImage(ImageProxy image, int rotation) {
        if (!RTMPPublisher.getInstance().isWorked()) {
            Log.d((String)TAG, (String)("rtmp not  worked  no handle handleImage " + rotation + " image rotation " + image.getImageInfo().getRotationDegrees()));
            return;
        }
        byte[] data = ConvertUtils.YUV_420_888toNV12(image, rotation);
        RTMPPublisher.getInstance().encodeVideo(data);
    }
}

