/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.encode;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import com.rtmpx.library.config.Config;
import com.rtmpx.library.encode.Encoder;
import com.rtmpx.library.publish.RTMPPublisher;
import com.rtmpx.library.rtmp.RTMPFrame;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoEncoder
extends Encoder<byte[]>
implements Handler.Callback {
    private static final String TAG = "VideoEncoder";
    private MediaCodec mAsyncVideoCodec;
    private AtomicBoolean mEncodeStarted = new AtomicBoolean(false);
    private Queue<Integer> mIndexQueue = new ConcurrentLinkedDeque<Integer>();
    private ByteBuffer mSps;
    private ByteBuffer mPps;
    private HandlerThread mWorkThread;
    private Handler mWorkHandler;
    private static final int MSG_START = 0;

    public VideoEncoder(Config mConfig) {
        super(mConfig);
        this.checkThread();
    }

    private void checkThread() {
        if (null == this.mWorkThread || !this.mWorkThread.isAlive() || this.mWorkThread.isInterrupted()) {
            this.mWorkThread = new HandlerThread("VRVideoEncoder"){

                protected void onLooperPrepared() {
                    super.onLooperPrepared();
                    VideoEncoder.this.mWorkHandler = new Handler(this.getLooper(), (Handler.Callback)VideoEncoder.this);
                    VideoEncoder.this.mWorkHandler.obtainMessage(0).sendToTarget();
                }
            };
            this.mWorkThread.start();
        }
    }

    @Override
    public void config() throws Exception {
        try {
            this.mAsyncVideoCodec = MediaCodec.createEncoderByType((String)"video/avc");
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mConfig.getVideoWidth(), (int)this.mConfig.getVideoHeight());
            mediaFormat.setInteger("bitrate", this.mConfig.getBitRate());
            mediaFormat.setInteger("frame-rate", this.mConfig.getFrameRate());
            mediaFormat.setInteger("color-format", this.getOptimalFormat("video/avc"));
            MediaCodecInfo.CodecCapabilities capabilities = this.mAsyncVideoCodec.getCodecInfo().getCapabilitiesForType("video/avc");
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevels = capabilities.profileLevels;
            int leve = -1;
            int profile = -1;
            if (null != codecProfileLevels) {
                List<MediaCodecInfo.CodecProfileLevel> highProfileLevelList = Collections.synchronizedList(new LinkedList());
                for (MediaCodecInfo.CodecProfileLevel profileLevel : codecProfileLevels) {
                    if (8 != profileLevel.profile) continue;
                    Log.i((String)TAG, (String)("add high profile level [profile = " + profileLevel.profile + ", level = " + profileLevel.level));
                    highProfileLevelList.add(profileLevel);
                }
                if (!highProfileLevelList.isEmpty()) {
                    Collections.sort(highProfileLevelList, (o1, o2) -> o2.profile - o1.profile + o2.level - o1.level);
                    leve = ((MediaCodecInfo.CodecProfileLevel)highProfileLevelList.get((int)0)).level;
                    profile = ((MediaCodecInfo.CodecProfileLevel)highProfileLevelList.get((int)0)).profile;
                }
            }
            if (-1 != leve) {
                Log.i((String)TAG, (String)("select level is " + leve));
                mediaFormat.setInteger("level", leve);
            }
            if (-1 != profile) {
                Log.i((String)TAG, (String)("select profile is " + profile));
                mediaFormat.setInteger("profile", profile);
            }
            mediaFormat.setInteger("i-frame-interval", this.mConfig.getIFrameInterval());
            this.mAsyncVideoCodec.configure(mediaFormat, null, null, 1);
            this.mAsyncVideoCodec.setCallback((MediaCodec.Callback)this);
            Log.i((String)TAG, (String)("mediaFormat is " + mediaFormat.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getOptimalFormat(String mime) {
        MediaCodecList list = new MediaCodecList(0);
        MediaCodecInfo[] infos = list.getCodecInfos();
        MediaCodecInfo.CodecCapabilities cap = null;
        block0: for (MediaCodecInfo info : infos) {
            if (!info.isEncoder()) continue;
            for (String type : info.getSupportedTypes()) {
                if (!type.equals(mime)) continue;
                cap = info.getCapabilitiesForType(mime);
                continue block0;
            }
        }
        int color_formatYUV420Flexible = 2135033992;
        if (null == cap) {
            Log.i((String)TAG, (String)"cap is null select default COLOR_FormatYUV420Flexible");
            return color_formatYUV420Flexible;
        }
        for (int i = 0; i < cap.colorFormats.length; ++i) {
            if (cap.colorFormats[i] != 21) continue;
            Log.i((String)TAG, (String)"select COLOR_FormatYUV420SemiPlanar");
            return cap.colorFormats[i];
        }
        Log.i((String)TAG, (String)"no match , select default COLOR_FormatYUV420Flexible");
        return color_formatYUV420Flexible;
    }

    @Override
    public void setStartTime(long startTime) {
        this.mStartTime = startTime;
    }

    @Override
    public void start() {
        this.mEncodedFrameCount = 0;
        if (null == this.mAsyncVideoCodec) {
            try {
                this.config();
                this.startEncoder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.startEncoder();
        }
    }

    @Override
    public void encode(byte[] data) {
        if (null == this.mAsyncVideoCodec || !this.mEncodeStarted.get()) {
            Log.i((String)TAG, (String)"====mAsyncVideoCodec not start====");
            return;
        }
        try {
            this.enCodeFrame(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void enCodeFrame(byte[] encodeBuffer) throws Exception {
        Integer index = this.mIndexQueue.poll();
        if (index == null) {
            return;
        }
        ByteBuffer inputBuffer = this.mAsyncVideoCodec.getInputBuffer(index.intValue());
        inputBuffer.clear();
        int length = 0;
        if (null != encodeBuffer) {
            inputBuffer.put(encodeBuffer);
            length = encodeBuffer.length;
            ++this.mEncodedFrameCount;
            this.mAsyncVideoCodec.queueInputBuffer(index.intValue(), 0, length, SystemClock.uptimeMillis() * 1000L - this.mStartTime, 0);
        }
    }

    private void startEncoder() {
        if (null == this.mAsyncVideoCodec || this.mEncodeStarted.get()) {
            return;
        }
        this.mAsyncVideoCodec.start();
        this.mEncodeStarted.set(true);
        Log.i((String)TAG, (String)"====mAsyncVideoCodec.start====");
    }

    @Override
    public void stop() {
        super.stop();
        this.mIndexQueue.clear();
        try {
            if (null != this.mAsyncVideoCodec) {
                this.mAsyncVideoCodec.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mAsyncVideoCodec = null;
        this.mEncodeStarted.set(false);
        this.mStartTime = 0L;
    }

    @Override
    public void release() {
        this.mAsyncVideoCodec = null;
    }

    @Override
    public ByteBuffer getSps() {
        return this.mSps;
    }

    @Override
    public ByteBuffer getPps() {
        return this.mPps;
    }

    public void onInputBufferAvailable(MediaCodec codec, int index) {
        this.mIndexQueue.add(index);
    }

    public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        try {
            this.handleOutput(codec, index, info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleOutput(MediaCodec codec, int index, MediaCodec.BufferInfo info) throws Exception {
        ByteBuffer outputBuffer = codec.getOutputBuffer(index);
        if (null != outputBuffer && info.size > 0) {
            byte[] tmpBuffer = new byte[outputBuffer.remaining()];
            outputBuffer.get(tmpBuffer);
            RTMPFrame frame = new RTMPFrame();
            frame.setType(0);
            frame.setData(tmpBuffer);
            frame.setPresentationTimeUs(SystemClock.uptimeMillis() - this.mStartTime);
            frame.setBufferInfo(info);
            RTMPPublisher.getInstance().addFrame(frame);
            Log.i((String)TAG, (String)("mPresentationTimeUs == " + info.presentationTimeUs));
        }
        codec.releaseOutputBuffer(index, true);
    }

    public void onError(MediaCodec codec, MediaCodec.CodecException e) {
        Log.i((String)TAG, (String)("=======onError=======" + e.toString()));
    }

    public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        Log.i((String)TAG, (String)("=======onOutputFormatChanged=======" + format.toString()));
        this.mSps = format.getByteBuffer("csd-0");
        this.mPps = format.getByteBuffer("csd-1");
    }

    public boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 0: {
                try {
                    this.config();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

