/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.encode;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import com.rtmpx.library.config.Config;
import com.rtmpx.library.encode.Encoder;
import com.rtmpx.library.publish.RTMPPublisher;
import com.rtmpx.library.rtmp.RTMPFrame;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioEncoder
extends Encoder<byte[]>
implements Handler.Callback {
    private static final String TAG = "AudioEncoder";
    private MediaCodec mAsyncAudioCodec;
    private AtomicBoolean mEncodeStarted = new AtomicBoolean(false);
    private Queue<Integer> mIndexQueue = new ConcurrentLinkedDeque<Integer>();
    private ByteBuffer mSps;
    private HandlerThread mWorkThread;
    private Handler mWorkHandler;
    private static final int MSG_START = 0;

    public AudioEncoder(Config mConfig) {
        super(mConfig);
        this.checkThread();
    }

    private void checkThread() {
        if (null == this.mWorkThread || !this.mWorkThread.isAlive() || this.mWorkThread.isInterrupted()) {
            this.mWorkThread = new HandlerThread("VRAudioEncoder"){

                protected void onLooperPrepared() {
                    super.onLooperPrepared();
                    AudioEncoder.this.mWorkHandler = new Handler(this.getLooper(), (Handler.Callback)AudioEncoder.this);
                    AudioEncoder.this.mWorkHandler.obtainMessage(0).sendToTarget();
                }
            };
            this.mWorkThread.start();
        }
    }

    @Override
    public void config() throws Exception {
        try {
            this.mAsyncAudioCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
            MediaFormat format = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)44100, (int)2);
            format.setInteger("bitrate", 96000);
            format.setInteger("max-input-size", 8192);
            this.mAsyncAudioCodec.configure(format, null, null, 1);
            this.mAsyncAudioCodec.setCallback((MediaCodec.Callback)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        this.mEncodedFrameCount = 0;
        if (null == this.mAsyncAudioCodec) {
            try {
                this.config();
                this.startEncoder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.startEncoder();
        }
    }

    @Override
    public void encode(byte[] data) {
        if (null == this.mAsyncAudioCodec || !this.mEncodeStarted.get()) {
            Log.i((String)TAG, (String)"====mAsyncAudioCodec not start====");
            return;
        }
        try {
            this.enCodeFrame(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void enCodeFrame(byte[] encodeBuffer) throws Exception {
        Integer index = this.mIndexQueue.poll();
        if (index == null) {
            return;
        }
        ByteBuffer inputBuffer = this.mAsyncAudioCodec.getInputBuffer(index.intValue());
        inputBuffer.clear();
        int length = 0;
        if (null != encodeBuffer) {
            inputBuffer.put(encodeBuffer);
            length = encodeBuffer.length;
            ++this.mEncodedFrameCount;
            this.mAsyncAudioCodec.queueInputBuffer(index.intValue(), 0, length, SystemClock.uptimeMillis() * 1000L - this.mStartTime, 0);
        }
    }

    private void startEncoder() {
        if (null == this.mAsyncAudioCodec || this.mEncodeStarted.get()) {
            return;
        }
        this.mAsyncAudioCodec.start();
        this.mEncodeStarted.set(true);
        Log.i((String)TAG, (String)"====mAsyncAudioCodec.start====");
    }

    @Override
    public void stop() {
        super.stop();
        this.mIndexQueue.clear();
        try {
            if (null != this.mAsyncAudioCodec) {
                this.mAsyncAudioCodec.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mAsyncAudioCodec = null;
        this.mEncodeStarted.set(false);
        this.mStartTime = 0L;
    }

    @Override
    public void release() {
        this.mAsyncAudioCodec = null;
    }

    @Override
    public ByteBuffer getSps() {
        return this.mSps;
    }

    @Override
    public ByteBuffer getPps() {
        return null;
    }

    public void onInputBufferAvailable(MediaCodec codec, int index) {
        this.mIndexQueue.add(index);
    }

    public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        try {
            this.handleOutput(codec, index, info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleOutput(MediaCodec codec, int index, MediaCodec.BufferInfo info) throws Exception {
        ByteBuffer outputBuffer = codec.getOutputBuffer(index);
        if (null != outputBuffer && info.size > 0) {
            byte[] tmpBuffer = new byte[outputBuffer.remaining()];
            outputBuffer.get(tmpBuffer);
            RTMPFrame frame = new RTMPFrame();
            frame.setType(1);
            frame.setData(tmpBuffer);
            frame.setPresentationTimeUs(SystemClock.uptimeMillis() - this.mStartTime);
            frame.setBufferInfo(info);
            RTMPPublisher.getInstance().addFrame(frame);
        }
        codec.releaseOutputBuffer(index, true);
    }

    public void onError(MediaCodec codec, MediaCodec.CodecException e) {
        Log.i((String)TAG, (String)("=======onError=======" + e.toString()));
    }

    public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        Log.i((String)TAG, (String)("=======onOutputFormatChanged=======" + format.toString()));
        this.mSps = format.getByteBuffer("csd-0");
    }

    public boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 0: {
                try {
                    this.config();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

