/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.camera.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.display.DisplayManager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.interop.Camera2CameraControl;
import androidx.camera.camera2.interop.Camera2Interop;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.rtmpx.library.camera.ICamera;
import com.rtmpx.library.camera.ICameraPreviewCallback;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraXImplView
extends FrameLayout
implements ICamera {
    private static final String TAG = "VRCameraViewCameraXImpl";
    private PreviewView mFinderView;
    private int mDisplayId = -1;
    private int mLensFacing = 1;
    private DisplayManager mDisplayManager;
    private ExecutorService mCameraExecutor;
    private DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            if (displayId == CameraXImplView.this.mDisplayId) {
                Log.i((String)CameraXImplView.TAG, (String)("Rotation changed: " + CameraXImplView.this.getDisplay().getRotation()));
                if (CameraXImplView.this.mImageAnalyzer != null) {
                    CameraXImplView.this.mImageAnalyzer.setTargetRotation(CameraXImplView.this.getDisplay().getRotation());
                }
            }
        }
    };
    private ProcessCameraProvider mCameraProvider = null;
    private Preview mPreview = null;
    private ImageAnalysis mImageAnalyzer = null;
    private Camera mCamera = null;
    private Size mTargetResolution = new Size(1080, 1920);
    private Range<Integer> DEFAULT_PREVIEW_RANGE = new Range((Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(30));
    private Range<Integer> mPreviewRange = this.DEFAULT_PREVIEW_RANGE;
    private CameraSelector mCameraSelector;
    private ICameraPreviewCallback mPreviewCallback;
    private AtomicBoolean mAutoExposure = new AtomicBoolean(true);
    private AtomicBoolean mAutoFocus = new AtomicBoolean(true);

    public CameraXImplView(@NonNull Context context) {
        this(context, null);
    }

    public CameraXImplView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraXImplView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews(context);
    }

    private void initViews(Context context) {
        this.mFinderView = new PreviewView(context);
        this.addView((View)this.mFinderView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        if (this.mDisplayManager != null) {
            this.mDisplayManager.registerDisplayListener(this.mDisplayListener, null);
        }
        this.mCameraExecutor = Executors.newSingleThreadExecutor();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setUpCamera(this.getContext());
    }

    private void setUpCamera(Context context) {
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)context);
        cameraProviderFuture.addListener(() -> {
            try {
                this.mCameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                switch (this.mLensFacing) {
                    case 1: {
                        this.hasBackCamera();
                        break;
                    }
                    case 0: {
                        this.hasFrontCamera();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Back and front camera are unavailable");
                    }
                }
                this.postDelayed(() -> this.setAnalyzer(), 500L);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }, ContextCompat.getMainExecutor((Context)context));
    }

    public void setTargetResolution(Size targetSize) {
        if (null == targetSize) {
            return;
        }
        if (targetSize.equals((Object)this.mTargetResolution)) {
            return;
        }
        this.mTargetResolution = targetSize;
    }

    public void setTargetResolution(int targetWidth, int targetHeight) {
        this.setTargetResolution(new Size(targetWidth, targetHeight));
    }

    public void setPreviewRange(Range mPreviewRange) {
        this.mPreviewRange = mPreviewRange;
    }

    public void setPreviewRange(int mLower, int mUpper) {
        this.setPreviewRange(new Range((Comparable)Integer.valueOf(mLower), (Comparable)Integer.valueOf(mUpper)));
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setAnalyzer() {
        final int rotation = this.getDisplay().getRotation();
        if (this.mCameraProvider == null) {
            throw new IllegalStateException("Camera initialization failed.");
        }
        this.createSelector();
        this.mPreview = new Preview.Builder().setTargetResolution(this.mTargetResolution).setTargetRotation(rotation).build();
        ImageAnalysis.Builder builder = new ImageAnalysis.Builder();
        Camera2Interop.Extender ext = new Camera2Interop.Extender((ExtendableBuilder)builder);
        Log.i((String)TAG, (String)("mPreviewRange is " + this.mPreviewRange.toString()));
        ext.setCaptureRequestOption(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mPreviewRange);
        this.mImageAnalyzer = builder.setTargetResolution(this.mTargetResolution).setTargetRotation(rotation).build();
        this.mImageAnalyzer.setAnalyzer((Executor)this.mCameraExecutor, new ImageAnalysis.Analyzer(){

            public void analyze(@NonNull ImageProxy image) {
                if (null == CameraXImplView.this.mPreviewCallback) {
                    image.close();
                    return;
                }
                CameraXImplView.this.mPreviewCallback.onPreviewFrame(image, rotation);
            }
        });
    }

    private Range<Integer> getOptimalPreviewRange() {
        CameraCharacteristics chars = null;
        try {
            String id;
            CameraManager mCameraManager = (CameraManager)this.getContext().getSystemService("camera");
            String[] cameraList = mCameraManager.getCameraIdList();
            if (null == cameraList || 0 == cameraList.length) {
                return this.DEFAULT_PREVIEW_RANGE;
            }
            String[] stringArray = cameraList;
            int n = stringArray.length;
            for (int i = 0; i < n && this.mLensFacing != (Integer)(chars = mCameraManager.getCameraCharacteristics(id = stringArray[i])).get(CameraCharacteristics.LENS_FACING); ++i) {
            }
            if (null == chars) {
                return this.DEFAULT_PREVIEW_RANGE;
            }
            Object[] ranges = (Range[])chars.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            if (null == ranges || 0 == ranges.length) {
                return this.DEFAULT_PREVIEW_RANGE;
            }
            Arrays.sort(ranges, (o1, o2) -> (Integer)o2.getLower() - (Integer)o1.getLower() + (Integer)o2.getUpper() - (Integer)o1.getUpper());
            Log.i((String)TAG, (String)("ranges is " + Arrays.toString(ranges)));
            Object niceRange = null;
            for (Object r : ranges) {
                if (r.getLower() != r.getUpper() || r.getUpper() != this.mPreviewRange.getUpper()) continue;
                niceRange = r;
                break;
            }
            if (null == niceRange) {
                return (Integer)this.mPreviewRange.getUpper() > (Integer)this.DEFAULT_PREVIEW_RANGE.getUpper() ? ranges[0] : this.DEFAULT_PREVIEW_RANGE;
            }
            return niceRange;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return this.DEFAULT_PREVIEW_RANGE;
        }
    }

    private void createSelector() {
        this.mCameraSelector = new CameraSelector.Builder().requireLensFacing(this.mLensFacing).build();
    }

    private boolean hasBackCamera() {
        if (this.mCameraProvider != null) {
            try {
                this.mCameraProvider.hasCamera(CameraSelector.DEFAULT_BACK_CAMERA);
                return true;
            }
            catch (CameraInfoUnavailableException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean hasFrontCamera() {
        if (this.mCameraProvider != null) {
            try {
                this.mCameraProvider.hasCamera(CameraSelector.DEFAULT_FRONT_CAMERA);
                return true;
            }
            catch (CameraInfoUnavailableException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private void bindCameraUseCases() {
        this.mCameraProvider.unbindAll();
        try {
            this.mCamera = this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), this.mCameraSelector, new UseCase[]{this.mPreview, this.mImageAnalyzer});
            if (this.mPreview != null) {
                this.mPreview.setSurfaceProvider(this.mFinderView.getSurfaceProvider());
            }
        }
        catch (Exception exc) {
            Log.e((String)TAG, (String)"Use case binding failed", (Throwable)exc);
        }
    }

    protected void onDetachedFromWindow() {
        this.stopPreview();
        this.release();
        super.onDetachedFromWindow();
    }

    @Override
    public void stopPreview() {
        if (null != this.mCameraProvider) {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalyzer});
            this.mCameraProvider.unbind(new UseCase[]{this.mPreview});
        }
    }

    @Override
    public void startPreview() {
        if (null == this.mCameraProvider || null == this.mCameraSelector) {
            this.postDelayed(() -> this.startPreview(), 1000L);
            return;
        }
        this.bindCameraUseCases();
    }

    @Override
    public float getMaxZoom() {
        if (null == this.mCamera) {
            return 0.0f;
        }
        return ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getMaxZoomRatio();
    }

    @Override
    public float getMinZoom() {
        if (null == this.mCamera) {
            return 0.0f;
        }
        return ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getMinZoomRatio();
    }

    @Override
    public float getZoom() {
        if (null == this.mCamera) {
            return 0.0f;
        }
        return ((ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()).getZoomRatio();
    }

    @Override
    public void setZoom(float level) {
        if (null == this.mCamera) {
            return;
        }
        this.mCamera.getCameraControl().setZoomRatio(level);
    }

    @Override
    @SuppressLint(value={"UnsafeOptInUsageError"})
    public int getMinExposureCompensation() {
        if (null == this.mCamera) {
            return 0;
        }
        return (Integer)this.mCamera.getCameraInfo().getExposureState().getExposureCompensationRange().getLower();
    }

    @Override
    @SuppressLint(value={"UnsafeOptInUsageError"})
    public int getMaxExposureCompensation() {
        if (null == this.mCamera) {
            return 0;
        }
        return (Integer)this.mCamera.getCameraInfo().getExposureState().getExposureCompensationRange().getUpper();
    }

    @Override
    @SuppressLint(value={"UnsafeOptInUsageError"})
    public int getExposureCompensation() {
        if (null == this.mCamera) {
            return 0;
        }
        return this.mCamera.getCameraInfo().getExposureState().getExposureCompensationIndex();
    }

    @Override
    @SuppressLint(value={"UnsafeOptInUsageError"})
    public void setExposureCompensation(int value) {
        if (null == this.mCamera) {
            return;
        }
        this.mCamera.getCameraControl().setExposureCompensationIndex(value);
    }

    @Override
    public void setAutoExposure(boolean toggle) {
        if (null == this.mCamera) {
            return;
        }
        this.mAutoExposure.set(toggle);
        this.setCaptureRequestOptions();
    }

    @Override
    public boolean autoExposure() {
        return this.mAutoExposure.get();
    }

    @Override
    public void autoFocus() {
        this.mAutoFocus.set(true);
        this.startFocus(new Rect(this.mFinderView.getWidth() / 2, this.mFinderView.getHeight() / 2, 0, 0));
    }

    @Override
    public void manualFocus(Rect rect) {
        this.mAutoFocus.set(false);
        this.startFocus(rect);
    }

    private void startFocus(Rect rect) {
        if (null == this.mCamera) {
            return;
        }
        MeteringPointFactory pointFactory = this.mFinderView.getMeteringPointFactory();
        MeteringPoint point = pointFactory.createPoint((float)rect.left, (float)rect.top);
        FocusMeteringAction action = new FocusMeteringAction.Builder(point, 1).addPoint(point, 2).build();
        ListenableFuture future = this.mCamera.getCameraControl().startFocusAndMetering(action);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                CameraXImplView.this.setCaptureRequestOptions();
            }
        }, ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    private void setCaptureRequestOptions() {
        Camera2CameraControl.from((CameraControl)this.mCamera.getCameraControl()).setCaptureRequestOptions(new CaptureRequestOptions.Builder().setCaptureRequestOption(CaptureRequest.CONTROL_AE_LOCK, (Object)(!this.autoExposure() ? 1 : 0)).setCaptureRequestOption(CaptureRequest.CONTROL_AF_MODE, (Object)this.getAFControlMode()).build());
    }

    @Override
    public int getCameraId() {
        return this.mLensFacing;
    }

    @Override
    public void switchCamera(int cameraId) {
        this.mLensFacing = cameraId;
        this.stopPreview();
        this.createSelector();
        this.startPreview();
    }

    @Override
    public void setPreviewCallback(ICameraPreviewCallback previewCallback) {
        this.mPreviewCallback = previewCallback;
    }

    @Override
    public void release() {
        try {
            this.stopPreview();
            this.mCameraExecutor.shutdown();
            this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mDisplayListener = null;
        }
    }

    private int getAFControlMode() {
        return this.mAutoFocus.get() ? 4 : 2;
    }
}

