/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.text;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SessionGenerator {
    private static final Map<String, UUID> cache = new HashMap<String, UUID>();
    private static final String DEFAULT_KEY = "DEFAULT";
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private static UUID getDefaultUUID() {
        UUID u = cache.get(DEFAULT_KEY);
        if (u == null) {
            u = UUID.randomUUID();
            cache.put(DEFAULT_KEY, u);
        }
        return u;
    }

    public static String generateSessionId() {
        UUID u = SessionGenerator.getDefaultUUID();
        String prefix = SessionGenerator.toHex(u.getLeastSignificantBits(), 16);
        String key0 = SessionGenerator.toHex(Thread.currentThread().getId(), 4);
        String key1 = SessionGenerator.toHex(System.currentTimeMillis(), 8);
        String key2 = SessionGenerator.toHex(System.nanoTime(), 8);
        return prefix + key0 + key1 + key2;
    }

    private static String toHex(long i, int len) {
        char[] buf = new char[64];
        Arrays.fill(buf, '0');
        int charPos = 64;
        int radix = 16;
        long mask = radix - 1;
        do {
            buf[--charPos] = digits[(int)(i & mask)];
        } while ((i >>>= 4) != 0L);
        return new String(buf, 64 - len, len);
    }

    public static void main(String[] a) {
        System.out.println(SessionGenerator.toHex(274L, 10));
        System.out.println(SessionGenerator.toHex(1250322L, 3));
        System.out.println(SessionGenerator.generateSessionId());
    }
}

