/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.text;

import com.luna.common.utils.ObjectUtils;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTools {
    private static final Logger log = LoggerFactory.getLogger(MapTools.class);

    public static Object getParam(String paramName, Map<String, Object> mapParam, Class<?> clazz) {
        Map<String, Object> map = MapTools.checkMap(paramName, mapParam);
        if (map == null) {
            return null;
        }
        try {
            if (clazz == String.class) {
                return map.get(paramName).toString();
            }
            if (clazz == Date.class) {
                return new Date(Long.parseLong(map.get(paramName).toString()));
            }
            if (clazz == Long.class) {
                return Long.parseLong(map.get(paramName).toString());
            }
            if (clazz == Integer.class) {
                return Integer.valueOf(map.get(paramName).toString());
            }
        }
        catch (Exception e) {
            log.error("error in get param={}, hit={}", new Object[]{paramName, mapParam.toString(), e});
        }
        return null;
    }

    public static Map<String, Object> checkMap(String paramName, Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        Object o = map.get(paramName);
        if (ObjectUtils.isEmpty(o)) {
            return null;
        }
        return map;
    }
}

