/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.text;

import java.util.regex.Pattern;

public final class CT {
    private static final long serialVersionUID = 3070917046443378762L;
    private static final Pattern PATTERN = Pattern.compile("^\\+\\d+_\\d+$");
    private String countryCode;
    private String telephone;

    private CT() {
    }

    private CT(String s) {
        if (null == s || !PATTERN.matcher(s).find()) {
            throw new RuntimeException("\u533a\u57df\u53f7\u4e0d\u5408\u6cd5");
        }
        String[] split = s.split("_");
        this.setCountryCode(split[0].replaceFirst("\\+", ""));
        this.setTelephone(split[1]);
    }

    private CT(String countryCode, String telephone) {
        this.setCountryCode(countryCode);
        this.setTelephone(telephone);
    }

    public static CT build(String s) {
        return new CT(s);
    }

    public static CT build(String countryCode, String telephone) {
        return new CT(countryCode, telephone);
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.assertIsNumber(countryCode);
        this.countryCode = countryCode;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.assertIsNumber(telephone);
        this.telephone = telephone;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CT && this.toString().equals(obj.toString());
    }

    public String toString() {
        return "+" + this.getCountryCode() + "_" + this.getTelephone();
    }

    private void assertIsNumber(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum CC {
        AL("355", "A", "\u963f\u5c14\u5df4\u5c3c\u4e9a", "F"),
        DZ("213", "A", "\u963f\u5c14\u53ca\u5229\u4e9a", "F"),
        AF("93", "A", "\u963f\u5bcc\u6c57", "F"),
        AR("54", "A", "\u963f\u6839\u5ef7", "F"),
        IE("353", "A", "\u7231\u5c14\u5170", "F"),
        EG("20", "A", "\u57c3\u53ca", "F"),
        ET("251", "A", "\u57c3\u585e\u4fc4\u6bd4\u4e9a", "F"),
        EE("372", "A", "\u7231\u6c99\u5c3c\u4e9a", "F"),
        AE("971", "A", "\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd", "F"),
        AW("297", "A", "\u963f\u9c81\u5df4", "F"),
        OM("968", "A", "\u963f\u66fc", "F"),
        AD("376", "A", "\u5b89\u9053\u5c14", "F"),
        AO("244", "A", "\u5b89\u54e5\u62c9", "F"),
        AI("1264", "A", "\u5b89\u572d\u62c9", "F"),
        AG("1268", "A", "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe", "F"),
        AU("61", "A", "\u6fb3\u5927\u5229\u4e9a", "F"),
        AT("43", "A", "\u5965\u5730\u5229", "F"),
        AZ("994", "A", "\u963f\u585e\u62dc\u7586", "F"),
        AC("247", "A", "\u963f\u68ee\u677e\u5c9b", "F"),
        BB("1246", "B", "\u5df4\u5df4\u591a\u65af", "F"),
        PG("675", "B", "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a", "F"),
        BS("1242", "B", "\u5df4\u54c8\u9a6c", "F"),
        BY("375", "B", "\u767d\u4fc4\u7f57\u65af", "F"),
        BM("1441", "B", "\u767e\u6155\u5927", "F"),
        PK("92", "B", "\u5df4\u57fa\u65af\u5766", "F"),
        PY("595", "B", "\u5df4\u62c9\u572d", "F"),
        PS("970", "B", "\u5df4\u52d2\u65af\u5766", "F"),
        BH("973", "B", "\u5df4\u6797", "F"),
        PA("507", "B", "\u5df4\u62ff\u9a6c", "F"),
        BG("359", "B", "\u4fdd\u52a0\u5229\u4e9a", "F"),
        BR("55", "B", "\u5df4\u897f", "F"),
        MP("1670", "B", "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b", "F"),
        BJ("229", "B", "\u8d1d\u5b81", "F"),
        BE("32", "B", "\u6bd4\u5229\u65f6", "F"),
        PE("51", "B", "\u79d8\u9c81", "F"),
        IS("354", "B", "\u51b0\u5c9b", "F"),
        BW("267", "B", "\u535a\u8328\u74e6\u7eb3", "F"),
        PR("1", "B", "\u6ce2\u591a\u9ece\u5404", "F"),
        PL("48", "B", "\u6ce2\u5170", "F"),
        BO("591", "B", "\u73bb\u5229\u7ef4\u4e9a", "F"),
        BZ("501", "B", "\u4f2f\u5229\u5179", "F"),
        BA("387", "B", "\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3", "F"),
        BT("975", "B", "\u4e0d\u4e39", "F"),
        BF("226", "B", "\u5e03\u57fa\u7eb3\u6cd5\u7d22", "F"),
        BI("257", "B", "\u5e03\u9686\u8fea", "F"),
        KP("850", "C", "\u671d\u9c9c", "F"),
        GQ("240", "C", "\u8d64\u9053\u51e0\u5185\u4e9a", "F"),
        DK("45", "D", "\u4e39\u9ea6", "F"),
        DE("49", "D", "\u5fb7\u56fd", "F"),
        TL("670", "D", "\u4e1c\u5e1d\u6c76", "F"),
        TG("228", "D", "\u591a\u54e5", "F"),
        DO("1767", "D", "\u591a\u7c73\u5c3c\u52a0", "F"),
        DM("1809", "D", "\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd", "F"),
        EC("593", "E", "\u5384\u74dc\u591a\u5c14", "F"),
        ER("291", "E", "\u5384\u7acb\u7279\u91cc\u4e9a", "F"),
        RU("7", "E", "\u4fc4\u7f57\u65af", "F"),
        FR("33", "F", "\u6cd5\u56fd", "F"),
        FO("298", "F", "\u6cd5\u7f57\u7fa4\u5c9b", "F"),
        VA("39", "F", "\u68b5\u8482\u5188", "F"),
        PF("689", "F", "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a", "F"),
        GF("594", "F", "\u6cd5\u5c5e\u572d\u4e9a\u90a3", "F"),
        FJ("679", "F", "\u6590\u6d4e", "F"),
        PH("63", "F", "\u83f2\u5f8b\u5bbe", "F"),
        FI("358", "F", "\u82ac\u5170", "F"),
        CV("238", "F", "\u4f5b\u5f97\u89d2", "F"),
        GM("220", "G", "\u5188\u6bd4\u4e9a", "F"),
        CG("242", "G", "\u521a\u679c\uff08\u5e03\uff09", "F"),
        CD("243", "G", "\u521a\u679c\uff08\u91d1\uff09", "F"),
        GG("44", "G", "\u6839\u897f\u5c9b", "F"),
        GL("299", "G", "\u683c\u9675\u5170", "F"),
        GD("1473", "G", "\u683c\u6797\u7eb3\u8fbe", "F"),
        GE("995", "G", "\u683c\u9c81\u5409\u4e9a", "F"),
        CO("57", "G", "\u54e5\u4f26\u6bd4\u4e9a", "F"),
        CR("506", "G", "\u54e5\u65af\u8fbe\u9ece\u52a0", "F"),
        GP("590", "G", "\u74dc\u5fb7\u7f57\u666e\u5c9b", "F"),
        GU("1671", "G", "\u5173\u5c9b", "F"),
        CU("53", "G", "\u53e4\u5df4", "F"),
        GY("592", "G", "\u572d\u4e9a\u90a3", "F"),
        HT("509", "H", "\u6d77\u5730", "F"),
        KR("82", "H", "\u97e9\u56fd", "F"),
        KZ("7", "H", "\u54c8\u8428\u514b\u65af\u5766", "F"),
        ME("382", "H", "\u9ed1\u5c71\u5171\u548c\u56fd", "F"),
        NL("31", "H", "\u8377\u5170", "F"),
        AN("599", "H", "\u8377\u5c5e\u5b89\u7684\u5217\u65af\u7fa4\u5c9b", "F"),
        HN("504", "H", "\u6d2a\u90fd\u62c9\u65af", "F"),
        GH("233", "J", "\u52a0\u7eb3", "F"),
        CA("1", "J", "\u52a0\u62ff\u5927", "F"),
        KH("855", "J", "\u67ec\u57d4\u5be8", "F"),
        GA("241", "J", "\u52a0\u84ec", "F"),
        DJ("253", "J", "\u5409\u5e03\u63d0", "F"),
        CZ("420", "J", "\u6377\u514b\u5171\u548c\u56fd", "F"),
        KG("996", "J", "\u5409\u5c14\u5409\u65af\u65af\u5766", "F"),
        KI("686", "J", "\u57fa\u91cc\u5df4\u65af", "F"),
        GN("224", "J", "\u51e0\u5185\u4e9a", "F"),
        GW("245", "J", "\u51e0\u5185\u4e9a\u6bd4\u7ecd", "F"),
        ZW("263", "J", "\u6d25\u5df4\u5e03\u97e6", "F"),
        KY("1345", "K", "\u5f00\u66fc\u7fa4\u5c9b", "F"),
        CM("237", "K", "\u5580\u9ea6\u9686", "F"),
        QA("974", "K", "\u5361\u5854\u5c14", "F"),
        CC("61", "K", "\u79d1\u79d1\u65af\uff08\u57fa\u6797\uff09\u7fa4\u5c9b", "F"),
        HR("385", "K", "\u514b\u7f57\u5730\u4e9a", "F"),
        KM("269", "K", "\u79d1\u6469\u7f57", "F"),
        KE("254", "K", "\u80af\u5c3c\u4e9a", "F"),
        CI("225", "X", "\u79d1\u7279\u8fea\u6c83", "F"),
        KW("965", "K", "\u79d1\u5a01\u7279", "F"),
        CK("682", "K", "\u5e93\u514b\u7fa4\u5c9b", "F"),
        LS("266", "L", "\u83b1\u7d22\u6258", "F"),
        LO("856", "L", "\u8001\u631d", "F"),
        LV("371", "L", "\u62c9\u8131\u7ef4\u4e9a", "F"),
        LB("961", "L", "\u9ece\u5df4\u5ae9", "F"),
        LR("231", "L", "\u5229\u6bd4\u91cc\u4e9a", "F"),
        LY("218", "L", "\u5229\u6bd4\u4e9a", "F"),
        LI("423", "L", "\u5217\u652f\u6566\u58eb\u767b", "F"),
        LT("370", "L", "\u7acb\u9676\u5b9b", "F"),
        RE("262", "L", "\u7559\u5c3c\u6c6a\u5c9b", "F"),
        RO("40", "L", "\u7f57\u9a6c\u5c3c\u4e9a", "F"),
        LU("352", "L", "\u5362\u68ee\u5821", "F"),
        RW("250", "L", "\u5362\u65fa\u8fbe", "F"),
        MG("261", "M", "\u9a6c\u8fbe\u52a0\u65af\u52a0", "F"),
        IM("44", "M", "\u9a6c\u6069\u5c9b", "F"),
        MV("960", "M", "\u9a6c\u5c14\u4ee3\u592b", "F"),
        MT("356", "M", "\u9a6c\u8033\u4ed6", "F"),
        MY("60", "M", "\u9a6c\u6765\u897f\u4e9a", "F"),
        MW("265", "M", "\u9a6c\u62c9\u7ef4", "F"),
        ML("223", "M", "\u9a6c\u91cc", "F"),
        MU("230", "M", "\u6bdb\u91cc\u6c42\u65af", "F"),
        MR("222", "M", "\u6bdb\u91cc\u5854\u5c3c\u4e9a", "F"),
        MK("389", "M", "\u9a6c\u5176\u987f", "F"),
        MH("692", "M", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b", "F"),
        MQ("596", "M", "\u9a6c\u63d0\u5c3c\u514b\u5c9b", "F"),
        YT("262", "M", "\u9a6c\u7ea6\u7279", "F"),
        US("1", "M", "\u7f8e\u56fd", "T"),
        AS("1684", "M", "\u7f8e\u5c5e\u8428\u6469\u4e9a", "F"),
        VI("1340", "M", "\u7f8e\u5c5e\u7ef4\u4eac\u7fa4\u5c9b", "F"),
        MN("976", "M", "\u8499\u53e4", "F"),
        BD("880", "M", "\u5b5f\u52a0\u62c9", "F"),
        MS("1664", "M", "\u8499\u7279\u585e\u62c9\u7279", "F"),
        MM("95", "M", "\u7f05\u7538", "F"),
        MF("691", "M", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a", "F"),
        MD("373", "M", "\u6469\u5c14\u591a\u74e6", "F"),
        MA("212", "M", "\u6469\u6d1b\u54e5", "F"),
        MC("377", "M", "\u6469\u7eb3\u54e5", "F"),
        MZ("258", "M", "\u83ab\u6851\u6bd4\u514b", "F"),
        MX("52", "M", "\u58a8\u897f\u54e5", "F"),
        NA("264", "N", "\u7eb3\u7c73\u6bd4\u4e9a", "F"),
        ZA("27", "N", "\u5357\u975e", "F"),
        AQ("672", "N", "\u5357\u6781\u6d32", "F"),
        NR("674", "N", "\u7459\u9c81", "F"),
        NP("977", "N", "\u5c3c\u6cca\u5c14", "F"),
        NI("505", "N", "\u5c3c\u52a0\u62c9\u74dc", "F"),
        NE("227", "N", "\u5c3c\u65e5\u5c14", "F"),
        NG("234", "N", "\u5c3c\u65e5\u5229\u4e9a", "F"),
        NU("683", "N", "\u7ebd\u57c3", "F"),
        NF("672", "N", "\u8bfa\u798f\u514b\u5c9b", "F"),
        NO("47", "N", "\u632a\u5a01", "F"),
        PW("680", "P", "\u5e15\u52b3", "F"),
        PN("64", "P", "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b", "F"),
        PT("351", "P", "\u8461\u8404\u7259", "F"),
        JP("81", "R", "\u65e5\u672c", "F"),
        SE("46", "R", "\u745e\u5178", "F"),
        CH("41", "R", "\u745e\u58eb", "F"),
        SV("503", "S", "\u8428\u5c14\u74e6\u591a", "F"),
        RS("381", "S", "\u585e\u5c14\u7ef4\u4e9a", "F"),
        SL("232", "S", "\u585e\u62c9\u5229\u6602", "F"),
        SN("221", "S", "\u585e\u5185\u52a0\u5c14", "F"),
        CY("357", "S", "\u585e\u6d66\u8def\u65af", "F"),
        SC("248", "S", "\u585e\u820c\u5c14", "F"),
        WS("685", "S", "\u8428\u6469\u4e9a", "F"),
        SA("966", "S", "\u6c99\u7279\u963f\u62c9\u4f2f", "F"),
        PM("508", "S", "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b", "F"),
        ST("239", "S", "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4", "F"),
        SH("290", "S", "\u5723\u8d6b\u52d2\u62ff", "F"),
        KN("1869", "S", "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af", "F"),
        LC("1758", "S", "\u5723\u5362\u897f\u4e9a", "F"),
        SM("378", "S", "\u5723\u9a6c\u529b\u8bfa", "F"),
        VC("1784", "S", "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af", "F"),
        LK("94", "S", "\u65af\u91cc\u5170\u5361", "F"),
        SK("421", "S", "\u65af\u6d1b\u4f10\u514b", "F"),
        SI("386", "S", "\u65af\u6d1b\u6587\u5c3c\u4e9a", "F"),
        SJ("47", "S", "\u65af\u74e6\u5c14\u5df4\u7279\u548c\u626c\u9a6c\u5ef6\u5c9b", "F"),
        SZ("268", "S", "\u65af\u5a01\u58eb\u5170", "F"),
        SD("249", "S", "\u82cf\u4e39", "F"),
        SR("597", "S", "\u82cf\u91cc\u5357", "F"),
        SB("677", "S", "\u6240\u7f57\u95e8\u7fa4\u5c9b", "F"),
        SO("252", "S", "\u7d22\u9a6c\u91cc", "F"),
        TH("66", "T", "\u6cf0\u56fd", "F"),
        TJ("992", "T", "\u5854\u5409\u514b\u65af\u5766", "F"),
        TO("676", "T", "\u6c64\u52a0", "F"),
        TZ("255", "T", "\u5766\u6851\u5c3c\u4e9a", "F"),
        TC("1649", "T", "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b", "F"),
        TT("1868", "T", "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5", "F"),
        TR("90", "T", "\u571f\u8033\u5176", "F"),
        TM("993", "T", "\u571f\u5e93\u66fc\u65af\u5766", "F"),
        TN("216", "T", "\u7a81\u5c3c\u65af", "F"),
        TK("690", "T", "\u6258\u514b\u52b3", "F"),
        TV("688", "T", "\u56fe\u74e6\u5362", "F"),
        WF("681", "W", "\u74e6\u91cc\u65af\u548c\u798f\u56fe\u7eb3\u7fa4\u5c9b", "F"),
        VU("678", "W", "\u74e6\u52aa\u963f\u56fe", "F"),
        GT("502", "W", "\u5371\u5730\u9a6c\u62c9", "F"),
        VE("58", "W", "\u59d4\u5185\u745e\u62c9", "F"),
        BN("673", "W", "\u6587\u83b1", "F"),
        UG("256", "W", "\u4e4c\u5e72\u8fbe", "F"),
        UA("380", "W", "\u4e4c\u514b\u5170", "F"),
        UY("598", "W", "\u4e4c\u62c9\u572d", "F"),
        UZ("998", "W", "\u4e4c\u5179\u522b\u514b\u65af\u5766", "F"),
        ES("34", "X", "\u897f\u73ed\u7259", "F"),
        GR("30", "X", "\u5e0c\u814a", "F"),
        SG("65", "X", "\u65b0\u52a0\u5761", "F"),
        NC("687", "X", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a", "F"),
        NZ("64", "X", "\u65b0\u897f\u5170", "F"),
        HU("36", "X", "\u5308\u7259\u5229", "F"),
        EH("212", "X", "\u897f\u6492\u54c8\u62c9", "F"),
        SY("963", "X", "\u53d9\u5229\u4e9a", "F"),
        JM("1876", "Y", "\u7259\u4e70\u52a0", "F"),
        AM("374", "Y", "\u4e9a\u7f8e\u5c3c\u4e9a", "F"),
        YE("967", "Y", "\u4e5f\u95e8", "F"),
        IT("39", "Y", "\u610f\u5927\u5229", "F"),
        IQ("964", "Y", "\u4f0a\u62c9\u514b", "F"),
        IR("98", "Y", "\u4f0a\u6717", "F"),
        IN("91", "Y", "\u5370\u5ea6", "F"),
        ID("62", "Y", "\u5370\u5ea6\u5c3c\u897f\u4e9a", "F"),
        UK("44", "Y", "\u82f1\u56fd", "F"),
        VG("1284", "Y", "\u82f1\u5c5e\u7ef4\u4eac\u7fa4\u5c9b", "F"),
        IL("972", "Y", "\u4ee5\u8272\u5217", "F"),
        JO("962", "Y", "\u7ea6\u65e6", "F"),
        VN("84", "Y", "\u8d8a\u5357", "F"),
        ZM("260", "Z", "\u8d5e\u6bd4\u4e9a", "F"),
        JE("44", "Z", "\u6cfd\u897f\u5c9b", "F"),
        TD("235", "Z", "\u4e4d\u5f97", "F"),
        GI("350", "Z", "\u76f4\u5e03\u7f57\u9640", "F"),
        CL("56", "Z", "\u667a\u5229", "F"),
        CF("236", "Z", "\u4e2d\u975e\u5171\u548c\u56fd", "F"),
        CN("86", "Z", "\u4e2d\u56fd\u5927\u9646", "T"),
        TW("886", "Z", "\u4e2d\u56fd\u53f0\u6e7e", "F"),
        MO("853", "Z", "\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a", "F"),
        HK("852", "Z", "\u4e2d\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a", "T");

        private final String c;
        private final String i;
        private final String n;
        private final String s;

        private CC(String c, String i, String n2, String s) {
            this.c = c;
            this.i = i;
            this.n = n2;
            this.s = s;
        }

        public String getC() {
            return this.c;
        }

        public String getI() {
            return this.i;
        }

        public String getN() {
            return this.n;
        }

        public String getS() {
            return this.s;
        }
    }
}

