/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.spring;

import com.google.common.collect.Maps;
import com.luna.common.exception.BaseException;
import com.luna.common.reflect.ReflectUtils;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringBeanService
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringBeanService.class);
    protected static ApplicationContext applicationContext = null;
    private static Map<String, Object> beanPool = Maps.newConcurrentMap();

    public static <T> T getBeanByName(String name, Class<T> clazz) throws BeansException {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static Object getBeanByName(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return applicationContext.getBeansOfType(clazz);
    }

    public static <T> T getSingleBeanByType(Class<T> clazz) throws Exception {
        if (beanPool.get(clazz.getName()) != null) {
            return (T)beanPool.get(clazz.getName());
        }
        T bean = SpringBeanService.doGetSingleBeanByType(clazz);
        beanPool.put(clazz.getName(), bean);
        return bean;
    }

    private static <T> T doGetSingleBeanByType(Class<T> clazz) throws Exception {
        String[] beanDefinitionNames;
        for (String beanName : beanDefinitionNames = applicationContext.getBeanDefinitionNames()) {
            Object beanByName = SpringBeanService.getBeanByName(beanName);
            Object target = ReflectUtils.getTarget(beanByName);
            if (!clazz.getName().equals(target.getClass().getName())) continue;
            return (T)beanByName;
        }
        log.error("can not find bean by type, class = {}", (Object)clazz.getName());
        throw BaseException.SYSTEM_ERROR;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringBeanService.applicationContext = applicationContext;
    }
}

