/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.sensitive;

import com.luna.common.sensitive.Convert;
import com.luna.common.sensitive.FieldConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public enum FieldType {
    MOBILE(Convert::mobile),
    ADDRESS(Convert::address),
    EMAIL(Convert::email),
    BANKCARD(Convert::bankCard),
    IDCARD(Convert::idCard),
    PASSWORD(Convert::all),
    CHINESE_NAME(Convert::chineseName);

    private static final Map<String, FieldType> fieldTypeMap;
    private final Function<String, String> defaultFunction;

    private FieldType(Function<String, String> defaultFunction) {
        this.defaultFunction = defaultFunction;
    }

    public static FieldType parseFieldType(String fieldName) {
        if (fieldTypeMap.containsKey(fieldName)) {
            return fieldTypeMap.get(fieldName);
        }
        return null;
    }

    public String convert(String value, FieldConfig fieldConfig) {
        if (fieldConfig != null && fieldConfig.getNeed() != null && fieldConfig.getNeed() == Boolean.FALSE) {
            return value;
        }
        Function<String, String> function = fieldConfig != null && fieldConfig.getFunction() != null ? fieldConfig.getFunction() : this.defaultFunction;
        return function.apply(value);
    }

    static {
        fieldTypeMap = new HashMap<String, FieldType>();
        fieldTypeMap.put("mobile", MOBILE);
        fieldTypeMap.put("telephone", MOBILE);
        fieldTypeMap.put("address", ADDRESS);
        fieldTypeMap.put("email", EMAIL);
        fieldTypeMap.put("bankcard", BANKCARD);
        fieldTypeMap.put("idcard", IDCARD);
        fieldTypeMap.put("password", PASSWORD);
        fieldTypeMap.put("chinesename", CHINESE_NAME);
    }
}

