/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.os.hardware;

import com.google.common.collect.Sets;
import com.luna.common.date.DateUnit;
import com.luna.common.date.DateUtils;
import com.luna.common.math.NumberUtil;
import com.luna.common.os.SystemInfoUtil;
import com.luna.common.os.hardware.FirmwareDTO;
import com.luna.common.os.hardware.Jvm;
import com.luna.common.os.hardware.Memory;
import com.luna.common.os.hardware.MotherboardDTO;
import com.luna.common.os.hardware.OshiHardware;
import com.luna.common.os.hardware.Processor;
import com.luna.common.os.hardware.SysFile;
import com.luna.common.os.hardware.SystemInfoDTO;
import com.luna.common.os.hardware.dto.JvmDTO;
import com.luna.common.os.hardware.dto.MemoryDTO;
import com.luna.common.os.hardware.dto.OshiHardwareDTO;
import com.luna.common.os.hardware.dto.ProcessorDTO;
import com.luna.common.os.hardware.dto.SysFileDTO;
import com.luna.common.text.Calculator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class OshiUtils {
    private static final Logger logger = LoggerFactory.getLogger(OshiUtils.class);
    private static final int OSHI_WAIT_SECOND = 1000;

    public static void main(String[] args) {
        OshiHardware oshiHardware = new OshiHardware();
        OshiUtils.refresh(oshiHardware, new SystemInfo());
        System.out.println(oshiHardware);
    }

    public static void refresh(OshiHardware oshiHardware, SystemInfo si) {
        Processor processor = OshiUtils.cpuInfo(si.getHardware().getProcessor());
        Memory memory = OshiUtils.memoryInfo(si.getHardware().getMemory());
        Jvm jvm = OshiUtils.jvmInfo();
        List<SysFile> list = OshiUtils.sysFiles(si.getOperatingSystem());
        SystemInfoDTO systemInfoDTO = OshiUtils.sysInfo();
        oshiHardware.setSystemInfoDTO(systemInfoDTO);
        oshiHardware.setJvm(jvm);
        oshiHardware.setSysFiles(list);
        oshiHardware.setProcessor(processor);
        oshiHardware.setMemory(memory);
    }

    public static OshiHardware baseInfo(SystemInfo si) {
        OshiHardware oshiHardware = new OshiHardware();
        HardwareAbstractionLayer hal = si.getHardware();
        oshiHardware = new OshiHardware();
        oshiHardware.setHostName("UNKNOWN-HOSTNAME");
        oshiHardware.setHostName(si.getOperatingSystem().getNetworkParams().getHostName());
        oshiHardware.setManufacturer(hal.getComputerSystem().getManufacturer());
        oshiHardware.setModel(hal.getComputerSystem().getModel());
        oshiHardware.setSerialNumber(hal.getComputerSystem().getSerialNumber());
        FirmwareDTO firmwareDTO = new FirmwareDTO();
        firmwareDTO.setManufacturer(hal.getComputerSystem().getFirmware().getManufacturer());
        firmwareDTO.setName(hal.getComputerSystem().getFirmware().getName());
        firmwareDTO.setDescription(hal.getComputerSystem().getFirmware().getDescription());
        firmwareDTO.setVersion(hal.getComputerSystem().getFirmware().getVersion());
        oshiHardware.setFirmwareDTO(firmwareDTO);
        MotherboardDTO motherboardDTO = new MotherboardDTO();
        motherboardDTO.setManufacturer(hal.getComputerSystem().getBaseboard().getManufacturer());
        motherboardDTO.setModel(hal.getComputerSystem().getBaseboard().getModel());
        motherboardDTO.setVersion(hal.getComputerSystem().getBaseboard().getVersion());
        motherboardDTO.setSerialNumber(hal.getComputerSystem().getBaseboard().getSerialNumber());
        oshiHardware.setMotherboardDTO(motherboardDTO);
        oshiHardware.setMacAddressSet(OshiUtils.acquireMACAddressSet(hal));
        Processor processor = new Processor();
        processor.setName(hal.getProcessor().toString());
        processor.setPhysicalPackageCount(hal.getProcessor().getPhysicalPackageCount());
        processor.setPhysicalProcessorCount(hal.getProcessor().getPhysicalProcessorCount());
        processor.setLogicalProcessorCount(hal.getProcessor().getLogicalProcessorCount());
        processor.setProcessorId(hal.getProcessor().getProcessorIdentifier().getProcessorID());
        oshiHardware.setProcessor(processor);
        logger.info("init oshiHardwareDTO success, oshiHardwareDTO={}", (Object)oshiHardware);
        oshiHardware.setSystemInfoDTO(OshiUtils.sysInfo());
        return oshiHardware;
    }

    public static Set<String> acquireMACAddressSet(HardwareAbstractionLayer hal) {
        HashSet macAddressSet = Sets.newHashSet();
        List networkIFs = hal.getNetworkIFs();
        for (NetworkIF net : networkIFs) {
            if (net.getDisplayName().startsWith("Microsoft Wi-Fi Direct Virtual") || net.getDisplayName().startsWith("Microsoft Hosted Network Virtual Adapter") || net.getDisplayName().startsWith("VirtualBox") || net.getDisplayName().startsWith("VMware") || net.getDisplayName().startsWith("Cisco AnyConnect") || net.getDisplayName().startsWith("TAP-Windows Adapter")) continue;
            macAddressSet.add(net.getMacaddr());
        }
        return macAddressSet;
    }

    public static Processor cpuInfo(CentralProcessor processor) {
        Processor processorDTO = new Processor();
        processorDTO.setName(processor.toString());
        processorDTO.setPhysicalPackageCount(processor.getPhysicalPackageCount());
        processorDTO.setPhysicalProcessorCount(processor.getPhysicalProcessorCount());
        processorDTO.setLogicalProcessorCount(processor.getLogicalProcessorCount());
        processorDTO.setProcessorId(processor.getProcessorIdentifier().getProcessorID());
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = user + nice + cSys + idle + iowait + irq + softirq + steal;
        processorDTO.setUser(NumberUtil.div((float)user, (float)totalCpu));
        processorDTO.setNice(NumberUtil.div((float)nice, (float)totalCpu));
        processorDTO.setSystem(NumberUtil.div((float)cSys, (float)totalCpu));
        processorDTO.setIdle(NumberUtil.div((float)idle, (float)totalCpu));
        processorDTO.setWait(NumberUtil.div((float)iowait, (float)totalCpu));
        return processorDTO;
    }

    public static Memory memoryInfo(GlobalMemory memory) {
        Memory memoryDTO = new Memory();
        memoryDTO.setMemeryTotal(memory.getTotal());
        memoryDTO.setSwapTotal(memory.getVirtualMemory().getSwapTotal());
        memoryDTO.setUsed(memory.getTotal() - memory.getAvailable());
        memoryDTO.setFree(memory.getAvailable());
        return memoryDTO;
    }

    public static Jvm jvmInfo() {
        Properties props = System.getProperties();
        Jvm jvm = new Jvm();
        jvm.setTotal(Runtime.getRuntime().totalMemory());
        jvm.setMax(Runtime.getRuntime().maxMemory());
        jvm.setFree(Runtime.getRuntime().freeMemory());
        jvm.setVersion(props.getProperty("java.version"));
        jvm.setHome(props.getProperty("java.home"));
        jvm.setRunTime(OshiUtils.getRunTime(DateUnit.HOUR));
        jvm.setStartTime(OshiUtils.getStartTime());
        return jvm;
    }

    public static Date getStartTime() {
        return DateUtils.getServerStartDate();
    }

    public static Long getRunTime(DateUnit unit) {
        return DateUtils.between(DateUtils.getCurrentDate(), DateUtils.getServerStartDate(), Optional.ofNullable(unit).orElse(DateUnit.HOUR));
    }

    public static List<SysFile> sysFiles(OperatingSystem os) {
        FileSystem fileSystem = os.getFileSystem();
        List fileStores = fileSystem.getFileStores(true);
        ArrayList<SysFile> list = new ArrayList<SysFile>();
        for (OSFileStore fs : fileStores) {
            long free = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            long used = total - free;
            SysFile sysFile = new SysFile();
            sysFile.setDirName(fs.getMount());
            sysFile.setSysTypeName(fs.getType());
            sysFile.setTypeName(fs.getName());
            sysFile.setTotal(total);
            sysFile.setFree(free);
            sysFile.setUsed(used);
            list.add(sysFile);
        }
        return list;
    }

    public static SystemInfoDTO sysInfo() {
        Properties props = System.getProperties();
        SystemInfoDTO systemInfoDTO = new SystemInfoDTO();
        systemInfoDTO.setComputerName(SystemInfoUtil.getHostName());
        systemInfoDTO.setComputerIp(SystemInfoUtil.getIP());
        systemInfoDTO.setOsName(props.getProperty("os.name"));
        systemInfoDTO.setOsArch(props.getProperty("os.arch"));
        systemInfoDTO.setUserDir(props.getProperty("user.dir"));
        return systemInfoDTO;
    }

    public static SysFileDTO convertSysFile(SysFile sysFile) {
        if (sysFile == null) {
            return null;
        }
        SysFileDTO sysFileDTO = new SysFileDTO();
        sysFileDTO.setDirName(sysFile.getDirName());
        sysFileDTO.setSysTypeName(sysFile.getSysTypeName());
        sysFileDTO.setTypeName(sysFile.getTypeName());
        sysFileDTO.setTotal(Calculator.getPrintSize(sysFile.getTotal()));
        sysFileDTO.setFree(Calculator.getPrintSize(sysFile.getFree()));
        sysFileDTO.setUsed(Calculator.getPrintSize(sysFile.getUsed()));
        sysFileDTO.setUsage(NumberUtil.decimalFormat("0.##%", NumberUtil.div(sysFile.getUsed(), sysFile.getTotal())));
        return sysFileDTO;
    }

    public static MemoryDTO convertMemory(Memory memory) {
        if (memory == null) {
            return null;
        }
        MemoryDTO memoryDTO = new MemoryDTO();
        memoryDTO.setMemeryTotal(Calculator.getPrintSize(memory.getMemeryTotal()));
        memoryDTO.setSwapTotal(Calculator.getPrintSize(memory.getSwapTotal()));
        memoryDTO.setUsed(Calculator.getPrintSize(memory.getUsed()));
        memoryDTO.setFree(Calculator.getPrintSize(memory.getFree()));
        return memoryDTO;
    }

    public static ProcessorDTO converProcessor(Processor processor) {
        if (processor == null) {
            return null;
        }
        ProcessorDTO processorDTO = new ProcessorDTO();
        processorDTO.setName(processor.getName());
        processorDTO.setPhysicalPackageCount(processor.getPhysicalPackageCount());
        processorDTO.setPhysicalProcessorCount(processor.getPhysicalProcessorCount());
        processorDTO.setLogicalProcessorCount(processor.getLogicalProcessorCount());
        processorDTO.setProcessorId(processor.getProcessorId());
        processorDTO.setUser(NumberUtil.decimalFormat("0.##%", processor.getUser()));
        processorDTO.setNice(NumberUtil.decimalFormat("0.##%", processor.getNice()));
        processorDTO.setSystem(NumberUtil.decimalFormat("0.##%", processor.getSystem()));
        processorDTO.setIdle(NumberUtil.decimalFormat("0.##%", processor.getIdle()));
        processorDTO.setWait(NumberUtil.decimalFormat("0.##%", processor.getWait()));
        return processorDTO;
    }

    public static JvmDTO convertJvm(Jvm jvm) {
        if (jvm == null) {
            return null;
        }
        JvmDTO jvmDTO = new JvmDTO();
        jvmDTO.setTotal(Calculator.getPrintSize(jvm.getTotal()));
        jvmDTO.setMax(Calculator.getPrintSize(jvm.getMax()));
        jvmDTO.setFree(Calculator.getPrintSize(jvm.getFree()));
        jvmDTO.setVersion(jvm.getVersion());
        jvmDTO.setHome(jvm.getHome());
        jvmDTO.setRunTime(OshiUtils.getRunTime(null).toString());
        jvmDTO.setStartTime(DateUtils.formatDateTime(OshiUtils.getStartTime()));
        return jvmDTO;
    }

    public static OshiHardwareDTO oshiHardware2oshiHardwareDTO(OshiHardware oshiHardware) {
        if (oshiHardware == null) {
            return null;
        }
        OshiHardwareDTO oshiHardwareDTO = new OshiHardwareDTO();
        oshiHardwareDTO.setSystemInfoDTO(oshiHardware.getSystemInfoDTO());
        oshiHardwareDTO.setSysFiles(oshiHardware.getSysFiles().stream().map(OshiUtils::convertSysFile).collect(Collectors.toList()));
        oshiHardwareDTO.setProcessorDTO(OshiUtils.converProcessor(oshiHardware.getProcessor()));
        oshiHardwareDTO.setHostName(oshiHardware.getHostName());
        oshiHardwareDTO.setManufacturer(oshiHardware.getManufacturer());
        oshiHardwareDTO.setModel(oshiHardware.getModel());
        oshiHardwareDTO.setSerialNumber(oshiHardware.getSerialNumber());
        oshiHardwareDTO.setFirmwareDTO(oshiHardware.getFirmwareDTO());
        oshiHardwareDTO.setMotherboardDTO(oshiHardware.getMotherboardDTO());
        oshiHardwareDTO.setMacAddressSet(oshiHardware.getMacAddressSet());
        oshiHardwareDTO.setJvmDTO(OshiUtils.convertJvm(oshiHardware.getJvm()));
        oshiHardwareDTO.setMemoryDTO(OshiUtils.convertMemory(oshiHardware.getMemory()));
        return oshiHardwareDTO;
    }
}

