/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.high;

import com.luna.common.net.HttpUtils;
import com.luna.common.net.async.CustomAsyncHttpResponse;
import com.luna.common.net.async.CustomResponseConsumer;
import com.luna.common.net.hander.AsyncHttpClientResponseHandler;
import com.luna.common.net.high.HttpHighLevelUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.apache.hc.core5.http.nio.entity.PathEntityProducer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AsyncHttpUtils {
    private static final HttpAsyncClientBuilder HTTP_ASYNC_CLIENT_BUILDER = HttpAsyncClients.custom();
    private static CloseableHttpAsyncClient asyncClient;

    public static void refresh() {
        HTTP_ASYNC_CLIENT_BUILDER.setDefaultCookieStore((CookieStore)HttpUtils.COOKIE_STORE);
        asyncClient = HTTP_ASYNC_CLIENT_BUILDER.build();
        asyncClient.start();
    }

    public static void init() {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)HttpUtils.SOCKET_TIME_OUT)).build();
        PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_1).build()).setConnectionConfigResolver(route -> {
            if (route.isSecure()) {
                return ConnectionConfig.custom().setConnectTimeout(Timeout.ofMinutes((long)2L)).setSocketTimeout(Timeout.ofMinutes((long)2L)).setValidateAfterInactivity(TimeValue.ofMinutes((long)1L)).setTimeToLive(TimeValue.ofHours((long)1L)).build();
            }
            return ConnectionConfig.custom().setConnectTimeout(Timeout.ofMinutes((long)1L)).setSocketTimeout(Timeout.ofMinutes((long)1L)).setValidateAfterInactivity(TimeValue.ofSeconds((long)15L)).setTimeToLive(TimeValue.ofMinutes((long)15L)).build();
        }).setTlsConfigResolver(host -> {
            if (host.getSchemeName().equalsIgnoreCase("localhost")) {
                return TlsConfig.custom().setSupportedProtocols(new TLS[]{TLS.V_1_3}).setHandshakeTimeout(Timeout.ofSeconds((long)10L)).build();
            }
            return TlsConfig.DEFAULT;
        }).build();
        CharCodingConfig codingConfig = CharCodingConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        asyncClient = HTTP_ASYNC_CLIENT_BUILDER.setIOReactorConfig(ioReactorConfig).setConnectionManager((AsyncClientConnectionManager)connectionManager).setCharCodingConfig(codingConfig).evictExpiredConnections().evictIdleConnections(TimeValue.ofSeconds((long)HttpUtils.CONNECT_TIMEOUT)).setHttp1Config(Http1Config.DEFAULT).build();
    }

    public static void basicAuth(String userName, String password, String host) {
        HttpUtils.authContext(userName, password, host, "Basic");
    }

    public static void digestAuth(String userName, String password, String host) {
        HttpUtils.authContext(userName, password, host, "Digest");
    }

    public static void setProxy(String host, Integer port, String username, String password) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            AsyncHttpUtils.setAuth(host, port, username, password);
        }
        AsyncHttpUtils.setProxy(host, port);
    }

    public static void setProxy(Integer port) {
        AsyncHttpUtils.setProxy("127.0.0.1", port);
    }

    public static void setProxy(String host, Integer port) {
        HttpHost proxy = new HttpHost(host, port.intValue());
        HTTP_ASYNC_CLIENT_BUILDER.setProxy(proxy);
        AsyncHttpUtils.refresh();
    }

    public static void destroy() {
        asyncClient.close(CloseMode.GRACEFUL);
    }

    public static void setAuth(String host, String user, String password) {
        AsyncHttpUtils.setAuth(host, 80, user, password);
    }

    public static void setAuth(String host, Integer port, String user, String password) {
        CredentialsProvider provider = CredentialsProviderBuilder.create().add(new HttpHost(host, port.intValue()), user, password.toCharArray()).build();
        HTTP_ASYNC_CLIENT_BUILDER.setDefaultCredentialsProvider(provider);
        AsyncHttpUtils.refresh();
    }

    public static <T> CustomAsyncHttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, Path file, AsyncHttpClientResponseHandler<T> responseHandler) throws IOException {
        AsyncRequestProducer producer = AsyncHttpUtils.getProducer(host, path, headers, queries, (AsyncEntityProducer)new PathEntityProducer(file, new OpenOption[]{StandardOpenOption.READ}), Method.POST.toString());
        return AsyncHttpUtils.doAsyncRequest(producer, responseHandler);
    }

    public static <T> CustomAsyncHttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, File file, AsyncHttpClientResponseHandler<T> responseHandler) {
        AsyncRequestProducer producer = AsyncHttpUtils.getProducer(host, path, headers, queries, (AsyncEntityProducer)new FileEntityProducer(file), Method.POST.toString());
        return AsyncHttpUtils.doAsyncRequest(producer, responseHandler);
    }

    public static <T> CustomAsyncHttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, String body, AsyncHttpClientResponseHandler<T> responseHandler) {
        AsyncRequestProducer producer = AsyncHttpUtils.getProducer(host, path, headers, queries, (AsyncEntityProducer)new StringAsyncEntityProducer((CharSequence)body), Method.POST.toString());
        return AsyncHttpUtils.doAsyncRequest(producer, responseHandler);
    }

    public static <T> CustomAsyncHttpResponse doGet(String host, String path, Map<String, String> headers, Map<String, String> queries, AsyncHttpClientResponseHandler<T> responseHandler) {
        AsyncRequestProducer producer = AsyncHttpUtils.getProducer(host, path, headers, queries, Method.GET.toString());
        return AsyncHttpUtils.doAsyncRequest(producer, responseHandler);
    }

    public static <T> CustomAsyncHttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, AsyncHttpClientResponseHandler<T> responseHandler) {
        AsyncRequestProducer producer = AsyncHttpUtils.getProducer(host, path, headers, queries, Method.POST.toString());
        return AsyncHttpUtils.doAsyncRequest(producer, responseHandler);
    }

    public static AsyncRequestProducer getProducer(String host, String path, Map<String, String> headers, Map<String, String> queries, String method) {
        return AsyncHttpUtils.getProducer(host, path, headers, queries, null, method);
    }

    public static AsyncRequestProducer getProducer(String host, String path, Map<String, String> headers, Map<String, String> queries, AsyncEntityProducer entityProducer, String method) {
        AsyncRequestBuilder builder = AsyncRequestBuilder.create((String)method);
        builder.setHttpHost(HttpHighLevelUtil.getHost(host));
        builder.setUri(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, builder);
        if (entityProducer != null) {
            builder.setEntity(entityProducer);
        }
        return builder.build();
    }

    public static <T> CustomAsyncHttpResponse doAsyncRequest(AsyncRequestProducer producer, final AsyncHttpClientResponseHandler<T> responseHandler) {
        return AsyncHttpUtils.doAsyncRequest(producer, new FutureCallback<CustomAsyncHttpResponse>(){

            public void completed(CustomAsyncHttpResponse result) {
                responseHandler.handleResponse(result);
            }

            public void failed(Exception ex) {
                throw new RuntimeException(ex);
            }

            public void cancelled() {
                throw new RuntimeException("cancelled");
            }
        });
    }

    public static CustomAsyncHttpResponse doAsyncRequest(AsyncRequestProducer producer, FutureCallback<CustomAsyncHttpResponse> callback) {
        return AsyncHttpUtils.doAsyncRequest(producer, CustomResponseConsumer.create(), callback);
    }

    public static <T> T doAsyncRequest(AsyncRequestProducer producer, AsyncResponseConsumer<T> consumer, FutureCallback<T> callback) {
        try {
            Future future = asyncClient.execute(producer, consumer, (HttpContext)HttpUtils.CLIENT_CONTEXT, callback);
            return (T)future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Future<CustomAsyncHttpResponse> doAsyncRequestFuture(AsyncRequestProducer producer, FutureCallback<CustomAsyncHttpResponse> callback) {
        return AsyncHttpUtils.doAsyncRequestFuture(producer, CustomResponseConsumer.create(), callback);
    }

    public static <T> Future<T> doAsyncRequestFuture(AsyncRequestProducer producer, AsyncResponseConsumer<T> consumer, FutureCallback<T> callback) {
        try {
            return asyncClient.execute(producer, consumer, (HttpContext)HttpUtils.CLIENT_CONTEXT, callback);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        AsyncHttpUtils.init();
        asyncClient.start();
    }
}

