/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.download;

import com.luna.common.net.HttpUtils;
import com.luna.common.net.download.DownloadTaskListener;
import com.luna.common.net.download.DownloadThread;
import com.luna.common.net.download.DownloadThreadEvent;
import com.luna.common.net.download.DownloadThreadListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadTask.class);
    long contentLength = -1L;
    String url;
    boolean acceptRanges;
    int threadCount;
    String localPath;
    List<Thread> threads;
    long receivedCount;
    DownloadTaskListener listener;
    CloseableHttpClient httpClient;
    boolean debug = true;

    public DownloadTask(String url, String localPath, int threadCount) {
        this.url = url;
        this.acceptRanges = false;
        this.threadCount = threadCount;
        this.localPath = localPath;
        this.threads = new ArrayList<Thread>();
        this.receivedCount = 0L;
    }

    public void addDownloadTaskListener(DownloadTaskListener listener) {
        this.listener = listener;
    }

    public void startDown() throws Exception {
        try {
            this.getDownloadFileInfo(this.httpClient);
            this.startDownloadThread();
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getDownloadProgress() {
        float progress = 0.0f;
        if (this.contentLength == -1L) {
            return -1.0f;
        }
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            progress = (float)((double)this.receivedCount * 100.0 / (double)this.contentLength);
        }
        return progress;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDownload() {
        long download;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            download = this.receivedCount;
        }
        return download;
    }

    private void getDownloadFileInfo(CloseableHttpClient httpClient) throws Exception {
        Header[] headers;
        HttpHead httpHead = new HttpHead(this.url);
        CloseableHttpResponse response = httpClient == null ? (CloseableHttpResponse)HttpUtils.doHead(this.url) : httpClient.execute((ClassicHttpRequest)httpHead);
        int statusCode = response.getCode();
        if (statusCode == 404) {
            throw new Exception("\u8d44\u6e90\u4e0d\u5b58\u5728!");
        }
        if (this.getDebug()) {
            for (Header header : response.getHeaders()) {
                log.info(header.getName() + ":" + header.getValue());
            }
            log.info("-----------------------------http head----------------");
        }
        if ((headers = response.getHeaders("Content-Length")).length > 0) {
            this.contentLength = Long.valueOf(headers[0].getValue());
            log.info("length : " + this.contentLength);
        }
        this.threadCount = this.contentLength < 102400L ? 1 : (this.contentLength < 0x100000L ? 2 : (this.contentLength < 0xA00000L ? 5 : (this.contentLength < 0x6400000L ? 10 : 20)));
        log.info("thread Count = " + this.threadCount);
        httpHead.abort();
        httpHead = new HttpHead(this.url);
        httpHead.addHeader("Range", (Object)("bytes=0-" + (this.contentLength - 1L)));
        response = httpClient == null ? (CloseableHttpResponse)HttpUtils.doHead(this.url) : httpClient.execute((ClassicHttpRequest)httpHead);
        if (response.getCode() == 206) {
            this.acceptRanges = true;
            log.info("support range");
        } else {
            this.acceptRanges = false;
            log.info("not support range");
        }
        httpHead.abort();
    }

    private void startDownloadThread() throws IOException, FileNotFoundException {
        final File file = new File(this.localPath);
        file.createNewFile();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.setLength(this.contentLength);
        raf.close();
        final Calendar time = Calendar.getInstance();
        final long startMili = System.currentTimeMillis();
        DownloadThreadListener threadListener = new DownloadThreadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void afterPerDown(DownloadThreadEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    DownloadTask.this.receivedCount += event.getCount();
                }
            }

            @Override
            public void downCompleted(DownloadThreadEvent event) {
                DownloadTask.this.threads.remove(event.getTarget());
                if (DownloadTask.this.threads.isEmpty()) {
                    long endMili = System.currentTimeMillis();
                    Calendar time1 = Calendar.getInstance();
                    log.info(file + "\u603b\u8017\u65f6\u4e3a\uff1a" + (endMili - startMili) + "\u6beb\u79d2");
                    log.info("time------------- \uff1a" + file + time1.compareTo(time));
                    DownloadTask.this.listener.downloadCompleted();
                }
                if (DownloadTask.this.getDebug()) {
                    log.info("\u5269\u4f59\u7ebf\u7a0b\u6570\uff1a" + DownloadTask.this.threads.size());
                }
            }
        };
        if (!this.acceptRanges) {
            log.info("\u4e0d\u652f\u6301\u591a\u7ebf\u7a0b\u4e0b\u8f7d\u65f6 startDownloadThread:: acceptRanges: {}", (Object)false);
            DownloadThread thread = new DownloadThread(this.url, 0L, this.contentLength, file, false);
            thread.addDownloadListener(threadListener);
            thread.start();
            this.threads.add(thread);
            return;
        }
        long perThreadLength = this.contentLength / (long)this.threadCount + 1L;
        long startPosition = 0L;
        long endPosition = perThreadLength;
        do {
            if (endPosition >= this.contentLength) {
                endPosition = this.contentLength - 1L;
            }
            DownloadThread thread = new DownloadThread(this.url, startPosition, endPosition, file);
            thread.addDownloadListener(threadListener);
            thread.start();
            this.threads.add(thread);
            startPosition = endPosition + 1L;
            endPosition += perThreadLength;
        } while (startPosition < this.contentLength);
    }
}

