/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.async;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;

public final class CustomResponseBody {
    private final byte[] bodyAsBytes;
    private final String bodyAsText;
    private final ContentType contentType;

    CustomResponseBody(byte[] bodyAsBytes, String bodyAsText, ContentType contentType) {
        this.bodyAsBytes = bodyAsBytes;
        this.bodyAsText = bodyAsText;
        this.contentType = contentType;
    }

    static CustomResponseBody create(String body, ContentType contentType) {
        Charset charset = (contentType != null ? contentType : ContentType.DEFAULT_TEXT).getCharset();
        byte[] bytes = body.getBytes(charset != null ? charset : StandardCharsets.US_ASCII);
        return new CustomResponseBody(bytes, null, contentType);
    }

    static CustomResponseBody create(byte[] body, ContentType contentType) {
        return new CustomResponseBody(body, null, contentType);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public byte[] getBodyBytes() {
        if (this.bodyAsBytes != null) {
            return this.bodyAsBytes;
        }
        if (this.bodyAsText != null) {
            Charset charset = (this.contentType != null ? this.contentType : ContentType.DEFAULT_TEXT).getCharset();
            return this.bodyAsText.getBytes(charset != null ? charset : StandardCharsets.US_ASCII);
        }
        return null;
    }

    public String getBodyText() {
        if (this.bodyAsBytes != null) {
            Charset charset = (this.contentType != null ? this.contentType : ContentType.DEFAULT_TEXT).getCharset();
            return new String(this.bodyAsBytes, charset != null ? charset : StandardCharsets.US_ASCII);
        }
        return this.bodyAsText;
    }

    public boolean isText() {
        return this.bodyAsText != null;
    }

    public boolean isBytes() {
        return this.bodyAsBytes != null;
    }

    public String toString() {
        return "SimpleBody{content length=" + (this.bodyAsBytes != null ? Integer.valueOf(this.bodyAsBytes.length) : "chunked") + ", content type=" + this.contentType + "}";
    }
}

