/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net;

import java.net.URL;
import java.util.Arrays;

public class IPAddressUtil {
    public static final String LOCAL_HOST = "127.0.0.1";
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;
    private static final long L_IPV6_DELIMS = 0L;
    private static final long H_IPV6_DELIMS = 0x28000000L;
    private static final long L_GEN_DELIMS = -8935000888854970368L;
    private static final long H_GEN_DELIMS = 671088641L;
    private static final long L_AUTH_DELIMS = 0x400000000000000L;
    private static final long H_AUTH_DELIMS = 671088641L;
    private static final long L_COLON = 0x400000000000000L;
    private static final long H_COLON = 0L;
    private static final long L_SLASH = 0x800000000000L;
    private static final long H_SLASH = 0L;
    private static final long L_BACKSLASH = 0L;
    private static final long H_BACKSLASH = 0x10000000L;
    private static final long L_NON_PRINTABLE = 0xFFFFFFFFL;
    private static final long H_NON_PRINTABLE = Long.MIN_VALUE;
    private static final long L_EXCLUDE = -8935000884560003073L;
    private static final long H_EXCLUDE = -9223372035915251711L;
    private static final char[] OTHERS = new char[]{'\u2047', '\u2048', '\u2049', '\u2100', '\u2101', '\u2105', '\u2106', '\u2a74', '\ufe55', '\ufe56', '\ufe5f', '\ufe6b', '\uff03', '\uff0f', '\uff1a', '\uff1f', '\uff20'};

    public static byte[] textToNumericFormatV4(String var0) {
        byte[] var1 = new byte[4];
        long var2 = 0L;
        int var4 = 0;
        boolean var5 = true;
        int var6 = var0.length();
        if (var6 != 0 && var6 <= 15) {
            for (int var7 = 0; var7 < var6; ++var7) {
                char var8 = var0.charAt(var7);
                if (var8 == '.') {
                    if (var5 || var2 < 0L || var2 > 255L || var4 == 3) {
                        return null;
                    }
                    var1[var4++] = (byte)(var2 & 0xFFL);
                    var2 = 0L;
                    var5 = true;
                    continue;
                }
                int var9 = Character.digit(var8, 10);
                if (var9 < 0) {
                    return null;
                }
                var2 *= 10L;
                var2 += (long)var9;
                var5 = false;
            }
            if (!var5 && var2 >= 0L && var2 < 1L << (4 - var4) * 8) {
                switch (var4) {
                    case 0: {
                        var1[0] = (byte)(var2 >> 24 & 0xFFL);
                    }
                    case 1: {
                        var1[1] = (byte)(var2 >> 16 & 0xFFL);
                    }
                    case 2: {
                        var1[2] = (byte)(var2 >> 8 & 0xFFL);
                    }
                    case 3: {
                        var1[3] = (byte)(var2 >> 0 & 0xFFL);
                    }
                }
                return var1;
            }
            return null;
        }
        return null;
    }

    public static byte[] textToNumericFormatV6(String var0) {
        int var12;
        if (var0.length() < 2) {
            return null;
        }
        char[] var5 = var0.toCharArray();
        byte[] var6 = new byte[16];
        int var7 = var5.length;
        int var8 = var0.indexOf("%");
        if (var8 == var7 - 1) {
            return null;
        }
        if (var8 != -1) {
            var7 = var8;
        }
        int var1 = -1;
        int var9 = 0;
        int var10 = 0;
        if (var5[var9] == ':' && var5[++var9] != ':') {
            return null;
        }
        int var11 = var9;
        boolean var3 = false;
        int var4 = 0;
        while (var9 < var7) {
            char var2;
            if ((var12 = Character.digit(var2 = var5[var9++], 16)) != -1) {
                var4 <<= 4;
                if ((var4 |= var12) > 65535) {
                    return null;
                }
                var3 = true;
                continue;
            }
            if (var2 != ':') {
                if (var2 == '.' && var10 + 4 <= 16) {
                    String var13 = var0.substring(var11, var7);
                    int var14 = 0;
                    int var15 = 0;
                    while ((var15 = var13.indexOf(46, var15)) != -1) {
                        ++var14;
                        ++var15;
                    }
                    if (var14 != 3) {
                        return null;
                    }
                    byte[] var16 = IPAddressUtil.textToNumericFormatV4(var13);
                    if (var16 == null) {
                        return null;
                    }
                    for (int var17 = 0; var17 < 4; ++var17) {
                        var6[var10++] = var16[var17];
                    }
                    var3 = false;
                    break;
                }
                return null;
            }
            var11 = var9;
            if (!var3) {
                if (var1 != -1) {
                    return null;
                }
                var1 = var10;
                continue;
            }
            if (var9 == var7) {
                return null;
            }
            if (var10 + 2 > 16) {
                return null;
            }
            var6[var10++] = (byte)(var4 >> 8 & 0xFF);
            var6[var10++] = (byte)(var4 & 0xFF);
            var3 = false;
            var4 = 0;
        }
        if (var3) {
            if (var10 + 2 > 16) {
                return null;
            }
            var6[var10++] = (byte)(var4 >> 8 & 0xFF);
            var6[var10++] = (byte)(var4 & 0xFF);
        }
        if (var1 != -1) {
            var12 = var10 - var1;
            if (var10 == 16) {
                return null;
            }
            for (var9 = 1; var9 <= var12; ++var9) {
                var6[16 - var9] = var6[var1 + var12 - var9];
                var6[var1 + var12 - var9] = 0;
            }
            var10 = 16;
        }
        if (var10 != 16) {
            return null;
        }
        byte[] var18 = IPAddressUtil.convertFromIPv4MappedAddress(var6);
        if (var18 != null) {
            return var18;
        }
        return var6;
    }

    public static boolean isIPv4LiteralAddress(String var0) {
        return IPAddressUtil.textToNumericFormatV4(var0) != null;
    }

    public static boolean isIPv6LiteralAddress(String var0) {
        return IPAddressUtil.textToNumericFormatV6(var0) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] var0) {
        if (IPAddressUtil.isIPv4MappedAddress(var0)) {
            byte[] var1 = new byte[4];
            System.arraycopy(var0, 12, var1, 0, 4);
            return var1;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] var0) {
        if (var0.length < 16) {
            return false;
        }
        return var0[0] == 0 && var0[1] == 0 && var0[2] == 0 && var0[3] == 0 && var0[4] == 0 && var0[5] == 0 && var0[6] == 0 && var0[7] == 0 && var0[8] == 0 && var0[9] == 0 && var0[10] == -1 && var0[11] == -1;
    }

    public static boolean match(char var0, long var1, long var3) {
        if (var0 < '@') {
            return (1L << var0 & var1) != 0L;
        }
        if (var0 < '\u0080') {
            return (1L << var0 - 64 & var3) != 0L;
        }
        return false;
    }

    public static int scan(String var0, long var1, long var3) {
        int var6;
        int var5 = -1;
        if (var0 != null && (var6 = var0.length()) != 0) {
            boolean var7 = false;
            while (++var5 < var6 && !(var7 = IPAddressUtil.match(var0.charAt(var5), var1, var3))) {
            }
            return var7 ? var5 : -1;
        }
        return -1;
    }

    public static int scan(String var0, long var1, long var3, char[] var5) {
        int var7;
        int var6 = -1;
        if (var0 != null && (var7 = var0.length()) != 0) {
            char var9;
            boolean var8 = false;
            char var10 = var5[0];
            while (++var6 < var7 && !(var8 = IPAddressUtil.match(var9 = var0.charAt(var6), var1, var3))) {
                if (var9 < var10 || Arrays.binarySearch(var5, var9) <= -1) continue;
                var8 = true;
                break;
            }
            return var8 ? var6 : -1;
        }
        return -1;
    }

    private static String describeChar(char var0) {
        if (var0 >= ' ' && var0 != '\u007f') {
            return var0 == '\\' ? "'\\'" : "'" + var0 + "'";
        }
        if (var0 == '\n') {
            return "LF";
        }
        return var0 == '\r' ? "CR" : "control char (code=" + var0 + ")";
    }

    private static String checkUserInfo(String var0) {
        int var1 = IPAddressUtil.scan(var0, -9223231260711714817L, -9223372035915251711L);
        return var1 >= 0 ? "Illegal character found in user-info: " + IPAddressUtil.describeChar(var0.charAt(var1)) : null;
    }

    private static String checkHost(String var0) {
        if (var0.startsWith("[") && var0.endsWith("]")) {
            if (IPAddressUtil.isIPv6LiteralAddress(var0 = var0.substring(1, var0.length() - 1))) {
                int var1 = var0.indexOf(37);
                if (var1 >= 0 && (var1 = IPAddressUtil.scan(var0 = var0.substring(var1), 0xFFFFFFFFL, -9223372036183687168L)) >= 0) {
                    return "Illegal character found in IPv6 scoped address: " + IPAddressUtil.describeChar(var0.charAt(var1));
                }
                return null;
            }
            return "Unrecognized IPv6 address format";
        }
        int var1 = IPAddressUtil.scan(var0, -8935000884560003073L, -9223372035915251711L);
        return var1 >= 0 ? "Illegal character found in host: " + IPAddressUtil.describeChar(var0.charAt(var1)) : null;
    }

    private static String checkAuth(String var0) {
        int var1 = IPAddressUtil.scan(var0, -9223231260711714817L, -9223372036586340352L);
        return var1 >= 0 ? "Illegal character found in authority: " + IPAddressUtil.describeChar(var0.charAt(var1)) : null;
    }

    public static String checkAuthority(URL var0) {
        if (var0 == null) {
            return null;
        }
        String var2 = var0.getUserInfo();
        String var1 = IPAddressUtil.checkUserInfo(var2);
        if (var1 != null) {
            return var1;
        }
        String var3 = var0.getHost();
        var1 = IPAddressUtil.checkHost(var3);
        if (var1 != null) {
            return var1;
        }
        return var3 == null && var2 == null ? IPAddressUtil.checkAuth(var0.getAuthority()) : null;
    }

    public static String checkExternalForm(URL var0) {
        if (var0 == null) {
            return null;
        }
        String var1 = var0.getUserInfo();
        int var2 = IPAddressUtil.scan(var1, 0x8000FFFFFFFFL, Long.MIN_VALUE);
        if (var2 >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(var1.charAt(var2));
        }
        var1 = IPAddressUtil.checkHostString(var0.getHost());
        return var1 != null ? var1 : null;
    }

    public static String checkHostString(String var0) {
        if (var0 == null) {
            return null;
        }
        int var1 = IPAddressUtil.scan(var0, 0x8000FFFFFFFFL, Long.MIN_VALUE, OTHERS);
        return var1 >= 0 ? "Illegal character found in host: " + IPAddressUtil.describeChar(var0.charAt(var1)) : null;
    }
}

