/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MoneyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoneyUtil.class);
    private static BigDecimal BIGDECIMAL_HUNDRED = new BigDecimal("100.00");
    public static String ZERO_STR = "0";
    public static String YUAN_STR = "\u00a5";
    public static int SCALE = 2;

    public static String fenToYuan(Long fen) {
        return MoneyUtil.convertLong2Str(fen);
    }

    public static String fenToYuanOnePoint(Long fen) {
        if (fen == null) {
            return null;
        }
        if (fen <= 0L) {
            return "0.0";
        }
        Double yuan = (double)fen.longValue() / 100.0;
        DecimalFormat df = new DecimalFormat("###0.0");
        return df.format(yuan);
    }

    public static double fen2Yuand(Long price) {
        if (price == null || price <= 0L) {
            return 0.0;
        }
        return (double)price.longValue() / 100.0;
    }

    public static String formatPrice(Double d) {
        try {
            return new DecimalFormat("0.##").format(d);
        }
        catch (Exception e) {
            LOGGER.error("DecimalFormat.format error! param={}", (Object)d, (Object)e);
            return null;
        }
    }

    public static String formatPrice(String d) {
        try {
            long cent = MoneyUtil.yuan2Fen(d);
            return MoneyUtil.formatPrice(MoneyUtil.fen2Yuand(cent));
        }
        catch (Exception e) {
            LOGGER.error("DecimalFormat.format error! param={}", (Object)d, (Object)e);
            return null;
        }
    }

    public static String convertLong2Str(Long lMoney) {
        if (lMoney == null) {
            return null;
        }
        return MoneyUtil.formatPrice(new BigDecimal(lMoney).multiply(new BigDecimal(0.01)).doubleValue());
    }

    public static String convert2Str(Long price) {
        return price == null ? "" : new BigDecimal(price).divide(new BigDecimal(100)).setScale(2, RoundingMode.FLOOR).toString();
    }

    public static String convert2WithDefaultStr(Long price) {
        String priceStr = MoneyUtil.convert2Str(price);
        if (StringUtils.isEmpty((Object)priceStr)) {
            return "0";
        }
        return priceStr;
    }

    public static BigDecimal fen2Yuan(long fen) {
        BigDecimal bigDecimalFen = new BigDecimal(fen);
        return bigDecimalFen.divide(BIGDECIMAL_HUNDRED, SCALE, 4);
    }

    public static BigDecimal getHalf(BigDecimal originPrice) {
        return originPrice.divide(new BigDecimal("2"), SCALE, 4);
    }

    public static long getFen(BigDecimal price) {
        return price.longValue();
    }

    public static Long yuan2Fen(Float yuan) {
        if (yuan == null) {
            return 0L;
        }
        return MoneyUtil.yuan2Fen(new BigDecimal(yuan.floatValue()));
    }

    public static long yuan2Fen(BigDecimal yuan) {
        return MoneyUtil.yuan2Fen(yuan, 0, RoundingMode.HALF_UP);
    }

    public static long yuan2Fen(String yuan) {
        return MoneyUtil.yuan2Fen(new BigDecimal(yuan), 0, RoundingMode.HALF_UP);
    }

    public static long yuan2Fen(BigDecimal yuan, int scale, RoundingMode roundingMode) {
        return yuan.multiply(BIGDECIMAL_HUNDRED).setScale(scale, roundingMode).longValue();
    }

    public static String convertFen2Yuan(Long fen) {
        String yuan = MoneyUtil.fenToYuan(fen);
        if (!StringUtils.isEmpty((Object)yuan)) {
            return YUAN_STR + yuan;
        }
        return yuan;
    }

    public static double longConvert2Double(long entryStr) {
        try {
            return BigDecimal.valueOf(entryStr).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).doubleValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static void main(String[] args) {
        System.out.println(MoneyUtil.convertFen2Yuan(101L));
        System.out.println(MoneyUtil.getFen(new BigDecimal("123.22")));
        System.out.println(MoneyUtil.getFen(new BigDecimal("123.2533")));
        System.out.println(MoneyUtil.getFen(new BigDecimal("123.6533")));
        System.out.println(MoneyUtil.getFen(new BigDecimal("123")));
        System.out.println(MoneyUtil.getFen(new BigDecimal("123.00")));
        System.out.println(MoneyUtil.yuan2Fen(new BigDecimal("123")));
        System.out.println(MoneyUtil.yuan2Fen(new BigDecimal("123.00")));
        System.out.println(MoneyUtil.convertLong2Str(2300L));
        System.out.println(MoneyUtil.convertLong2Str(100L));
        System.out.println(MoneyUtil.formatPrice(0.0));
        System.out.println(MoneyUtil.formatPrice("0.00"));
    }
}

