/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.io;

import com.luna.common.check.Assert;
import com.luna.common.constant.StreamProgress;
import com.luna.common.io.FastByteArrayOutputStream;
import com.luna.common.text.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public class NioUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        return NioUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileChannel inChannel, FileChannel outChannel) throws IOException {
        Assert.notNull((Object)inChannel, "In channel is null!");
        Assert.notNull((Object)outChannel, "Out channel is null!");
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IOException {
        return NioUtil.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IOException {
        return NioUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IOException {
        Assert.notNull((Object)in, "InputStream is null !");
        Assert.notNull((Object)out, "OutputStream is null !");
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 8192 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            while (in.read(byteBuffer) != -1) {
                byteBuffer.flip();
                size += (long)out.write(byteBuffer);
                byteBuffer.clear();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws IOException {
        FastByteArrayOutputStream out = NioUtil.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        NioUtil.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String readUtf8(FileChannel fileChannel) throws IOException {
        return NioUtil.read(fileChannel, CharsetUtil.CHARSET_UTF_8);
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IOException {
        return NioUtil.read(fileChannel, CharsetUtil.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IOException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(buffer).toString();
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

