/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file.compress;

import com.luna.common.file.FileNameUtil;
import com.luna.common.file.FileTools;
import com.luna.common.file.ZipUtil;
import com.luna.common.io.IoUtil;
import com.luna.common.text.StringTools;
import com.luna.common.utils.ObjectUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;

    public ZipWriter(File zipFile, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(zipFile, charset);
    }

    public ZipWriter(OutputStream out, Charset charset) {
        this.out = ZipUtil.getZipOutputStream(out, charset);
    }

    public ZipWriter(ZipOutputStream out) {
        this.out = out;
    }

    public static ZipWriter of(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter of(OutputStream out, Charset charset) {
        return new ZipWriter(out, charset);
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipUtil.getZipOutputStream(FileTools.getOutputStream(zipFile), charset);
    }

    public ZipWriter setLevel(int level) {
        this.out.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment) {
        this.out.setComment(comment);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter add(boolean withSrcDir, FileFilter filter, File ... files) throws IOException {
        for (File file : files) {
            String srcRootDir;
            try {
                srcRootDir = file.getCanonicalPath();
                if (!file.isDirectory() || withSrcDir) {
                    srcRootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            this._add(file, srcRootDir, filter);
        }
        return this;
    }

    public ZipWriter add(String path, InputStream in) throws IOException {
        path = Optional.ofNullable(path).orElse("");
        if (null == in) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (StringTools.isBlank((CharSequence)path)) {
                return this;
            }
        }
        return this.putEntry(path, in);
    }

    public ZipWriter add(String[] paths, InputStream[] ins) throws IOException {
        if (ObjectUtils.isEmpty(paths) || ObjectUtils.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        for (int i = 0; i < paths.length; ++i) {
            this.add(paths[i], ins[i]);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            IoUtil.close(this.out);
        }
    }

    private ZipWriter _add(File file, String srcRootDir, FileFilter filter) throws IOException {
        if (null == file || null != filter && !filter.accept(file)) {
            return this;
        }
        String subPath = FileNameUtil.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ObjectUtils.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (Object childFile : files) {
                    this._add((File)childFile, srcRootDir, filter);
                }
            }
        } else {
            this.putEntry(subPath, FileTools.getInputStream(file));
        }
        return this;
    }

    private ZipWriter putEntry(String path, InputStream in) throws IOException {
        try {
            this.out.putNextEntry(new ZipEntry(path));
            if (null != in) {
                IoUtil.copy(in, this.out);
            }
            this.out.closeEntry();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            IoUtil.close(in);
        }
        IoUtil.flush(this.out);
        return this;
    }
}

