/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file.compress;

import com.luna.common.anno.Filter;
import com.luna.common.file.FileTools;
import com.luna.common.file.ZipUtil;
import com.luna.common.io.IoUtil;
import com.luna.common.text.StringTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipReader
implements Closeable {
    private ZipFile zipFile;
    private ZipInputStream in;

    public ZipReader(File zipFile, Charset charset) {
        this.zipFile = ZipUtil.toZipFile(zipFile, charset);
    }

    public ZipReader(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipReader(InputStream in, Charset charset) {
        this.in = new ZipInputStream(in, charset);
    }

    public ZipReader(ZipInputStream zin) {
        this.in = zin;
    }

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(zipFile, charset);
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(in, charset);
    }

    public InputStream get(String path) throws IOException {
        if (null != this.zipFile) {
            ZipFile zipFile = this.zipFile;
            ZipEntry entry = zipFile.getEntry(path);
            if (null != entry) {
                return ZipUtil.getStream(zipFile, entry);
            }
        } else {
            try {
                ZipEntry zipEntry;
                this.in.reset();
                while (null != (zipEntry = this.in.getNextEntry())) {
                    if (!zipEntry.getName().equals(path)) continue;
                    return this.in;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public File readTo(File outFile) throws IOException {
        return this.readTo(outFile, null);
    }

    public File readTo(File outFile, Filter<ZipEntry> entryFilter) throws IOException {
        this.read(zipEntry -> {
            if (null == entryFilter || entryFilter.accept((ZipEntry)zipEntry)) {
                String path = zipEntry.getName();
                if ('\\' == File.separatorChar) {
                    path = StringTools.replace(path, "*", "_");
                }
                File outItemFile = new File(outFile, path);
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                } else {
                    try {
                        InputStream in = null != this.zipFile ? ZipUtil.getStream(this.zipFile, zipEntry) : this.in;
                        FileTools.write(in, outItemFile, false);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws IOException {
        if (null != this.zipFile) {
            this.readFromZipFile(consumer);
        } else {
            this.readFromStream(consumer);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        if (null != this.zipFile) {
            IoUtil.close(this.zipFile);
        } else {
            IoUtil.close(this.in);
        }
    }

    private void readFromZipFile(Consumer<ZipEntry> consumer) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(em.nextElement());
        }
    }

    private void readFromStream(Consumer<ZipEntry> consumer) throws IOException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }
}

